float4x4 	wvpMatrix 	: WorldViewProjection;

float3		ambientColor
<
	string UIName = "Ambient Material Color";
> = { 1.0f, 0.0f, 0.0f };

float distortionAmount
<
	string UIName = "Amount of distortion";
> = 0.1f;

float4 materialColor
<
	string UIName = "Curve Color";
> = { 1.0f, 0.5f, 0.1f, 1.0f };

struct VertexInput {
    float3 Position	: POSITION;
    float4 Color	: TEXCOORD0;
};

struct VertexOutput {
    float4 position	: POSITION;
    float3 color	: COLOR;
};

VertexOutput VS_Curve(VertexInput IN) {
    VertexOutput OUT;
    
    OUT.position = mul(float4(IN.Position,1.0f), wvpMatrix);
	OUT.color = IN.Color;
    return OUT;
}

float4 PS_Curve( VertexOutput OUT ) : COLOR
{
	return float4(OUT.color,1.0f);
}

technique Curve<bool quad=true; string material="framebufferDistort";>
{
    pass p0
    {		
		VertexShader = compile vs_2_0 VS_Curve();
		PixelShader = compile ps_2_0 PS_Curve();
		
		CullMode = none;
    }
}

texture texture_0;
sampler texture_0Sampler = 
sampler_state
{
    Texture = <texture_0>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

texture texture_1;
sampler texture_1Sampler = 
sampler_state
{
    Texture = <texture_1>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = mirror;
    AddressV = mirror;
};

struct OverdrawVertexInput
{
	float3 Position : POSITION;
	float2 uvCoord	: TEXCOORD0;
};

struct OverdrawVertexOutput
{
	float4 Position : POSITION;
	float2 uvCoord	: TEXCOORD0;
};

OverdrawVertexOutput VS_Overdraw( OverdrawVertexInput IN )
{
	OverdrawVertexOutput OUT;
	OUT.Position = float4(IN.Position, 1.0f);
	OUT.uvCoord = IN.uvCoord;
	return OUT;
}

float4 PS_Overdraw( OverdrawVertexOutput IN ) : COLOR
{
	float3 distortion = tex2D( texture_0Sampler, IN.uvCoord );
	clip( distortion.r+distortion.b - 0.001f );
	return tex2D( texture_1Sampler, IN.uvCoord + distortion.rb*distortionAmount )*materialColor;
}

float4 VS_Copy( float3 Position : POSITION ) : POSITION
{
	return float4( 0, 0, 0, 0 );
}
float4 PS_PixelShader( ) : COLOR
{
	return float4( 0, 0, 0, 0 );
}

technique Copy
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS_Copy();
		PixelShader = compile ps_2_0 PS_PixelShader();
	}
}

technique Overdraw
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS_Overdraw();
		PixelShader = compile ps_2_0 PS_Overdraw();
	}
}