
#include <wendy/Wendy.h>

using namespace moira;
using namespace wendy;

#include "Title.h"

TitleEffect::TitleEffect(demo::EffectType& type, const String& name):
  demo::Effect(type, name),
  size(*this, "Size", 0.f, 1.f)
{
}

bool TitleEffect::init(void)
{
  titleTexture = GL::Texture::readInstance("title");
  if (!titleTexture)
    return false;

  titlePass.setDefaultColor(ColorRGBA::WHITE);
  titlePass.setBlendFactors(GL_ONE, GL_ONE);
  titlePass.setDepthTesting(false);
  titlePass.setDepthWriting(false);
  
  GL::TextureLayer& titleLayer = titlePass.createTextureLayer();
  titleLayer.setTexture(titleTexture);
  titleLayer.setCombineMode(GL_MODULATE);

  return true;
}

void TitleEffect::update(Time deltaTime)
{
}

void TitleEffect::render(void) const
{
  GL::Renderer* renderer = GL::Renderer::get();

  renderer->begin2D();

  titlePass.apply();

  const float currentSize = size.getValue(getTimeElapsed());

  render::Sprite2 sprite;
  sprite.position.set(0.5f, 0.5f);
  sprite.size.set(currentSize, currentSize * titleTexture->getHeight() / (float) titleTexture->getWidth());
  sprite.render();

  renderer->end();

  renderChildren();
}

