
#include <wendy/Wendy.h>

using namespace moira;
using namespace wendy;

#include "Glow.h"
#include "Cloud.h"
#include "Stars.h"
#include "Greets.h"

GreetsEffect::GreetsEffect(demo::EffectType& type, const String& name):
  demo::Effect(type, name),
  outside(true)
{
}

bool GreetsEffect::init(void)
{
  glow = Glow::createInstance(256);
  if (!glow)
    return false;

  ball = render::Mesh::readInstance("greets");
  if (!ball)
    return false;

  const char* names[] = { "amc", "adamblair", "candela", "illuminati", "mso",
                          "mippo", "noice", "nd", "outbreak", "stacken",
			  "vovoid", "woorlic", NULL };

  RandomVolume volume(Vector3(-4.f, -4.f, 0.f),
                      Vector3(4.f, 4.f, -5.f));
  RandomRange angle(0.f, M_PI);

  const float distance = 20.f;

  {
    BezierPoint3 point;

    point.position.set(0.f, 0.f, distance);
    point.direction.set(0.f, 0.f, -1.f);

    motionTrack.points.push_back(point);

    point.position.set(0.f, 0.f, 0.f);
    point.direction.set(0.f, 0.f, -1.f);
    targetTrack.points.push_back(point);
  }

  for (unsigned int i = 0;  names[i] != NULL;  i++)
  {
    Ptr<Entry> entry = new Entry();

    Vector3 position = Vector3(0.f, 0.f, -distance * i) + volume.generate();

    entry->mesh = new render::MeshNode();
    entry->mesh->setMesh(ball);
    entry->mesh->getLocalTransform().position = position;
    scene.addNode(*entry->mesh);

    String name = "greets_";
    name.append(names[i]);

    entry->texture = GL::Texture::readInstance(name);
    if (!entry->texture)
      return false;

    entry->style = new render::Style();
    render::Technique& technique = entry->style->createTechnique();
    GL::Pass& pass = technique.createPass();
    pass.setDefaultColor(ColorRGBA::WHITE);
    pass.setBlendFactors(GL_ONE, GL_ONE);
    pass.setDepthWriting(false);
    GL::TextureLayer& layer = pass.createTextureLayer();
    layer.setTexture(entry->texture);
    layer.setCombineMode(GL_MODULATE);
    layer.setAddressMode(GL_CLAMP_TO_EDGE);

    const float size = 5.f;

    entry->sprite = new render::SpriteNode();
    entry->sprite->getLocalTransform().position.y = 2.f;
    entry->sprite->setSpriteSize(Vector2(size, size * entry->texture->getHeight() /
                                               (float) entry->texture->getWidth()));
    entry->sprite->setStyle(entry->style);
    entry->mesh->addChild(*entry->sprite);

    BezierPoint3 point;

    Quaternion rotation;
    rotation.setAxisRotation(Vector3(0.f, 0.f, -1.f), angle.generate());

    point.position = position + Vector3(0.f, 1.5f, 6.f);
    point.direction.set(distance, 0.f, -distance / 10.f);
    rotation.rotateVector(point.direction);
    motionTrack.points.push_back(point);

    point.position = position + Vector3(0.f, 1.5f, 0.f);
    point.direction = Vector3(0.f, 0.f, -distance / 6.f);
    targetTrack.points.push_back(point);

    entries.push_back(entry.detachObject());

    Ref<Cloud> cloud = Cloud::createInstance();
    if (!cloud)
      return false;

    CloudNode* cloudNode = new CloudNode();
    cloudNode->setCloud(cloud);
    cloudNode->getLocalTransform().position = position;
    scene.addNode(*cloudNode);
  }

  {
    const Vector3 away(distance, 0.f, -distance * (entries.size() + 1));

    BezierPoint3 point;

    point.position = away;
    point.direction.set(distance / 3.f, 0.f, -distance / 3.f);
    motionTrack.points.push_back(point);

    point.position = away;
    point.direction.set(distance / 3.f, 0.f, -distance / 3.f);
    targetTrack.points.push_back(point);
  }

  Ref<Stars> stars = Stars::createInstance(100.f);
  if (!stars)
    return false;

  starsNode = new StarsNode();
  starsNode->setStars(stars);
  scene.addNode(*starsNode);

  camera.setFOV(60.f);

  cameraNode = new render::CameraNode();
  cameraNode->setCameraName(camera.getName());
  scene.addNode(*cameraNode);

  return true;
}

void GreetsEffect::update(Time deltaTime)
{
  float progress = (float) getTimeElapsed() / (float) getDuration();

  const Vector3 position = motionTrack(progress);

  starsNode->getLocalTransform().position = position;

  cameraNode->getLocalTransform().position = position;

  Vector3 vector = (position - targetTrack(progress)).normalize();
  cameraNode->getLocalTransform().rotation.setVectorRotation(vector);

  scene.setTimeElapsed(getTimeElapsed());
}

void GreetsEffect::prepare(void) const
{
  render::Queue queue(camera);
  scene.enqueue(queue);
  glow->prepare(queue);
}

void GreetsEffect::render(void) const
{
  render::Queue queue(camera);
  scene.enqueue(queue);
  queue.render();

  glow->render();
}

