
#include <wendy/Wendy.h>

using namespace moira;
using namespace wendy;

#include "Glow.h"

void Glow::prepare(render::Queue& queue) const
{
  canvas->begin();
  canvas->clearColorBuffer();
  canvas->clearDepthBuffer();

  GL::Renderer* renderer = GL::Renderer::get();

  queue.getCamera().begin();

  const render::OperationList& operations = queue.getOperations();

  for (unsigned int i = 0;  i < operations.size();  i++)
  {
    const render::Operation& operation = *operations[i];

    renderer->pushTransform(operation.transform);

    if (const GL::Pass* pass = operation.technique->findPass("glow"))
      pass->apply();
    else
      blackPass.apply();
  
    if (operation.indexBuffer)
      operation.indexBuffer->render(*(operation.vertexBuffer),
				    operation.renderMode,
				    operation.start,
				    operation.count);
    else
      operation.vertexBuffer->render(operation.renderMode,
				     operation.start,
				     operation.count);

    renderer->popTransform();
  }

  queue.getCamera().end();

  canvas->end();

  if (shaders)
  {
    render::Sprite2 sprite;

    canvas->begin();
    canvas->clearColorBuffer();
    renderer->begin2D();

    vertPass.apply();
    sprite.position.set(0.5f, 0.5f);
    sprite.render();

    renderer->end();
    canvas->end();

    canvas->begin();
    canvas->clearColorBuffer();
    renderer->begin2D();

    horzPass.apply();
    sprite.position.set(0.5f, 0.5f);
    sprite.render();

    renderer->end();
    canvas->end();

    canvas->begin();
    canvas->clearColorBuffer();
    renderer->begin2D();

    vertPass.apply();
    sprite.position.set(0.5f, 0.5f);
    sprite.render();

    renderer->end();
    canvas->end();

    canvas->begin();
    canvas->clearColorBuffer();
    renderer->begin2D();

    horzPass.apply();
    sprite.position.set(0.5f, 0.5f);
    sprite.render();

    renderer->end();
    canvas->end();
  }
}

void Glow::render(void) const
{
  GL::Renderer* renderer = GL::Renderer::get();
  renderer->begin2D();

  glowPass.apply();

  render::Sprite2 sprite;

  if (shaders)
  {
    sprite.position.set(0.5f, 0.5f);
    sprite.render();
  }
  else
  {
    for (unsigned int i = 0;  i < 10;  i++)
    {
      sprite.position.set(0.5f + cosf(M_PI * 2.f * i / 9.f) / 70.f,
			  0.5f + sinf(M_PI * 2.f * i / 9.f) / 70.f);
      sprite.render();
    }
  }

  renderer->end();
}

Glow* Glow::createInstance(unsigned int size)
{
  Ptr<Glow> glow = new Glow();
  if (!glow->init(size))
    return NULL;

  return glow.detachObject();
}

Glow::Glow(void):
  shaders(false)
{
}

bool Glow::init(unsigned int size)
{
  canvas = GL::TextureCanvas::createInstance(size, size);
  if (!canvas)
    return false;

  Ref<GL::ShaderProgram> horzProgram = GL::ShaderProgram::readInstance("horzblur");
  Ref<GL::ShaderProgram> vertProgram = GL::ShaderProgram::readInstance("vertblur");

  if (horzProgram && vertProgram)
  {
    horzPass.setDepthTesting(false);
    horzPass.setDepthWriting(false);
    horzPass.setShaderProgram(horzProgram);

    GL::TextureLayer& horzLayer = horzPass.createTextureLayer();
    horzLayer.setTexture(&(canvas->getTexture()));
    horzLayer.setCombineMode(GL_MODULATE);
    horzLayer.setSamplerName("canvas");
    horzLayer.setAddressMode(GL_CLAMP_TO_EDGE);

    vertPass.setDepthTesting(false);
    vertPass.setDepthWriting(false);
    vertPass.setShaderProgram(vertProgram);

    GL::TextureLayer& vertLayer = vertPass.createTextureLayer();
    vertLayer.setTexture(&(canvas->getTexture()));
    vertLayer.setCombineMode(GL_MODULATE);
    vertLayer.setSamplerName("canvas");
    vertLayer.setAddressMode(GL_CLAMP_TO_EDGE);

    shaders = true;
  }

  blackPass.setDefaultColor(ColorRGBA::BLACK);

  glowPass.setDepthTesting(false);
  glowPass.setDepthWriting(false);
  GL::TextureLayer& glowLayer = glowPass.createTextureLayer();
  glowLayer.setTexture(&(canvas->getTexture()));
  glowLayer.setCombineMode(GL_MODULATE);

  if (shaders)
  {
    glowPass.setBlendFactors(GL_ONE, GL_ONE);
    glowPass.setDefaultColor(ColorRGBA(1.f, 1.f, 1.f, 1.f));
  }
  else
  {
    glowPass.setBlendFactors(GL_SRC_ALPHA, GL_ONE);
    glowPass.setDefaultColor(ColorRGBA(1.f, 1.f, 1.f, 0.15f));
  }

  return true;
}

