
class FrameEffect : public demo::Effect
{
public:
  FrameEffect(demo::EffectType& type, const String& name);
  bool init(void);
private:
  void update(Time deltaTime);
  void prepare(void) const;
  void render(void) const;
  void generateTracks(void);
  enum Sequence
  {
    INSIDE,
    OUTSIDE_OUT,
    OUTSIDE_ORBIT,
    OUTSIDE_IN,
  };
  Ptr<Glow> glow;
  Ptr<GL::TextureCanvas> frameCanvas;
  Ref<render::Mesh> mesh;
  render::Scene scene;
  render::Camera camera;
  render::CameraNode* cameraNode;
  render::MeshNode* domeNode;
  StarsNode* starsNode;
  BezierTrack3 track;
  unsigned int currentSequence;
  demo::EnumProperty sequence;
};

