
#include <wendy/Wendy.h>

using namespace moira;
using namespace wendy;

#include "Glow.h"
#include "Laser.h"
#include "Stars.h"
#include "Connect.h"

ConnectEffect::ConnectEffect(demo::EffectType& type, const String& name):
  demo::Effect(type, name),
  sequence(*this, "Sequence")
{
  sequence.addSymbol("Travelling", TRAVELLING);
  sequence.addSymbol("Beaming", BEAMING);
}

bool ConnectEffect::init(void)
{
  glow = Glow::createInstance(256);
  if (!glow)
    return false;

  render::Mesh* sphere = render::Mesh::readInstance("leaf");
  if (!sphere)
    return false;

  const unsigned int count = 9;

  RandomVolume volume(Vector3(-40.f, -40.f, 0.f),
                      Vector3(40.f, 40.f, 0.f));

  const Vector3 offset(0.f, 0.f, -5.f);

  for (unsigned int i = 0;  i < count;  i++)
  {
    render::MeshNode* node = new render::MeshNode();
    node->setMesh(sphere);
    scene.addNode(*node);
    nodes.push_back(node);

    Animation track;

    track.positions.points.resize(2);
    track.positions.points[0].position = volume.generate() + offset * (float) i;
    track.positions.points[0].direction = volume.generate();
    track.positions.points[1].position = offset * (float) i;
    track.positions.points[1].direction = volume.generate();

    track.rotations.points.resize(1);
    track.rotations.points[0].setAxisRotation(Vector3::X, M_PI / 2.f);

    tracks.push_back(track);
  }

  Ref<Stars> stars = Stars::createInstance(100.f);
  if (!stars)
    return false;

  starsNode = new StarsNode();
  starsNode->setStars(stars);
  scene.addNode(*starsNode);

  camera.setFOV(60.f);

  cameraNode = new render::CameraNode();
  cameraNode->setCameraName(camera.getName());
  scene.addNode(*cameraNode);

  BezierPoint3 point;

  point.position.set(offset.z * count / 3.f, 0.f, offset.z * count / 1.5f);
  point.direction.set(0.f, 0.f, -1.f);
  motionTrack.points.push_back(point);

  return true;
}

void ConnectEffect::update(Time deltaTime)
{
  const Time elapsed = getTimeElapsed();
  const Time start = sequence.getSequenceStart(elapsed);
  const Time duration = sequence.getSequenceDuration(elapsed);

  float progress = (float) (elapsed - start) / (float) duration;

  for (unsigned int i = 0;  i < nodes.size();  i++)
  {
    if (sequence.getValue(getTimeElapsed()) == TRAVELLING)
      tracks[i].evaluate(progress, nodes[i]->getLocalTransform());
    else
      tracks[i].evaluate(1.f, nodes[i]->getLocalTransform());
  }

  const Vector3 position = motionTrack(progress);

  starsNode->getLocalTransform().position = position;
  cameraNode->getLocalTransform().position = position;

  const unsigned int index = nodes.size() / 2;

  Vector3 vector = position - nodes[index]->getLocalTransform().position;
  vector.normalize();

  cameraNode->getLocalTransform().rotation.setVectorRotation(vector);

  scene.setTimeElapsed(elapsed);
}

void ConnectEffect::prepare(void) const
{
  render::Queue queue(camera);
  scene.enqueue(queue);

  if (sequence.getValue(getTimeElapsed()) == BEAMING)
  {
    Segment3 beam(Vector3(0.f, 0.f, 300.f), Vector3(0.f, 0.f, -300.f));
    enqueueLaserBeam(queue, beam, Transform3());
  }

  glow->prepare(queue);
}

void ConnectEffect::render(void) const
{
  render::Queue queue(camera);
  scene.enqueue(queue);

  if (sequence.getValue(getTimeElapsed()) == BEAMING)
  {
    Segment3 beam(Vector3(0.f, 0.f, 300.f), Vector3(0.f, 0.f, -300.f));
    enqueueLaserBeam(queue, beam, Transform3());
  }

  queue.render();

  glow->render();

  renderChildren();
}

