
#include <wendy/Wendy.h>

using namespace moira;
using namespace wendy;

#include "Cloud.h"

void Cloud::enqueue(render::Queue& queue, const Transform3& transform) const
{
  sprites.enqueue(queue, transform);
}

const Sphere& Cloud::getBounds(void) const
{
  return bounds;
}

Cloud* Cloud::createInstance(void)
{
  Ptr<Cloud> cloud = new Cloud();
  if (!cloud->init())
    return NULL;

  return cloud.detachObject();
}

Cloud::Cloud(void)
{
}

bool Cloud::init(void)
{
  sprites.style = render::Style::readInstance("cloud");
  if (!sprites.style)
    return false;

  RandomVolume volume(Vector3(-5.f, -5.f, -9.f), Vector3(5.f, 5.f, 9.f));
  RandomRange angle(0.f, M_PI * 2.f);

  const float size = 8.f;

  sprites.slots.resize(40);
  sprites.type = render::SPHERICAL_SPRITE;

  for (unsigned int i = 0;  i < sprites.slots.size();  i++)
  {
    sprites.slots[i].position = volume.generate();
    sprites.slots[i].size.set(size, size);
    sprites.slots[i].angle = angle.generate();
  }

  const float radius = (volume.min.length() + volume.max.length()) / 2.f + sqrtf(powf(size, 3.f));

  bounds.set(Vector3::ZERO, radius);
  return true;
}

void CloudNode::setCloud(Cloud* newCloud)
{
  cloud = newCloud;
  
  if (cloud)
    setLocalBounds(cloud->getBounds());
  else
    setLocalBounds(Sphere(Vector3::ZERO, 0.f));
}

void CloudNode::enqueue(render::Queue& queue, render::QueuePhase phase) const
{
  if (phase == render::COLLECT_GEOMETRY)
    cloud->enqueue(queue, getWorldTransform());

  render::SceneNode::enqueue(queue, phase);
}

