
#include <wendy/Wendy.h>

#include <audiere.h>

using namespace moira;
using namespace wendy;

namespace
{

audiere::AudioDevicePtr device = NULL;
audiere::SampleSourcePtr source = NULL;
audiere::OutputStreamPtr stream = NULL;

int sampleRate;
int frameCount;

void onPaused(void)
{
  stream->stop();
}

void onResumed(void)
{
  stream->play();
}

void onTimeChanged(void)
{
  demo::Editor* editor = demo::Editor::get();

  int position = editor->getTimeElapsed() * sampleRate;

  stream->setPosition(std::min(position, frameCount));
}

}

bool initializeSound(void)
{
  demo::Editor* editor = demo::Editor::get();

  String path = editor->getShow().getMusicPath().asString();
  if (!path.empty())
  {
    device = audiere::OpenDevice();
    if (!device)
      return false;

    source = audiere::OpenSampleSource(editor->getShow().getMusicPath().asString().c_str());
    if (!source)
      return false;

    int channels;
    audiere::SampleFormat format;

    source->getFormat(channels, sampleRate, format);

    stream = audiere::OpenSound(device, source);
    if (!stream)
      return false;

    frameCount = stream->getLength();
    //stream->setVolume(0.1);

    editor->getPausedSignal().connect(onPaused);
    editor->getResumedSignal().connect(onResumed);
    editor->getTimeChangedSignal().connect(onTimeChanged);
  }

  return true;
}

void shutdownSound(void)
{
  stream = NULL;
  source = NULL;
  device = NULL;
}

