///////////////////////////////////////////////////////////////////////
// Moira library
// Copyright (c) 2006 Camilla Berglund <elmindreda@elmindreda.org>
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any
// damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any
// purpose, including commercial applications, and to alter it and
// redistribute it freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you
//     must not claim that you wrote the original software. If you use
//     this software in a product, an acknowledgment in the product
//     documentation would be appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and
//     must not be misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//     distribution.
//
///////////////////////////////////////////////////////////////////////

#include <moira/Moira.h>

#include <stdlib.h>

///////////////////////////////////////////////////////////////////////

namespace moira
{
  
///////////////////////////////////////////////////////////////////////

namespace
{

Ptr<ImageCodec> imageCodecPNG;
Ptr<FontCodec> fontCodecXML;
Ptr<MeshCodec> meshCodecXML;

bool initialized = false;

bool initializeCodecs(void)
{
  imageCodecPNG = new ImageCodecPNG();
  fontCodecXML = new FontCodecXML();
  meshCodecXML = new MeshCodecXML();

  if (!Image::addSearchPath(Path(".")))
    return false;

  if (!Font::addSearchPath(Path(".")))
    return false;

  if (!Mesh::addSearchPath(Path(".")))
    return false;

  return true;
}

}

///////////////////////////////////////////////////////////////////////

bool initialize(void)
{
  if (initialized)
  {
    Log::writeWarning("Duplicate initialization of Moira ignored");
    return true;
  }

  atexit(shutdown);

  if (!initializeCodecs())
  {
    shutdown();
    return false;
  }

  initialized = true;
  return true;
}

void shutdown(void)
{
  imageCodecPNG = NULL;
  fontCodecXML = NULL;
  meshCodecXML = NULL;

  initialized = false;
}

///////////////////////////////////////////////////////////////////////

} /*namespace moira*/

///////////////////////////////////////////////////////////////////////
