///////////////////////////////////////////////////////////////////////
// Moira library
// Copyright (c) 2006 Camilla Berglund <elmindreda@elmindreda.org>
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any
// damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any
// purpose, including commercial applications, and to alter it and
// redistribute it freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you
//     must not claim that you wrote the original software. If you use
//     this software in a product, an acknowledgment in the product
//     documentation would be appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and
//     must not be misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//     distribution.
//
///////////////////////////////////////////////////////////////////////
#ifndef MOIRA_TRIANGLE_H
#define MOIRA_TRIANGLE_H
///////////////////////////////////////////////////////////////////////

#if MOIRA_HAVE_MATH_H
#include <math.h>
#endif

#include <vector>

///////////////////////////////////////////////////////////////////////

namespace moira
{
  
///////////////////////////////////////////////////////////////////////

/*! @brief Generic 2D triangle.
 */
class Triangle2
{
public:
  Triangle2(void);
  Triangle2(const Vector2& P0, const Vector2& P1, const Vector2& P2);
  Vector2 center(void) const;
  bool contains(const Vector2& point) const;
  void set(const Vector2& P0, const Vector2& P1, const Vector2& P2);
  void setDefaults(void);
  Vector2 P[3];
};

///////////////////////////////////////////////////////////////////////

/*! @brief Generic 3D triangle.
 */
class Triangle3
{
public:
  Triangle3(void);
  Triangle3(const Vector3& P0, const Vector3& P1, const Vector3& P2);
  Vector3 center(void) const;
  bool intersects(const Plane& plane) const;
  bool intersects(const Ray3& ray, float& distance) const;
  bool intersects(const Ray3& ray, float& distance, Vector3& normal, bool& inside) const;
  void set(const Vector3& P0, const Vector3& P1, const Vector3& P2);
  void setDefaults(void);
  Vector3 P[3];
};

///////////////////////////////////////////////////////////////////////

} /*namespace moira*/

///////////////////////////////////////////////////////////////////////
#endif /*MOIRA_TRIANGLE_H*/
///////////////////////////////////////////////////////////////////////
