///////////////////////////////////////////////////////////////////////
// Moira library
// Copyright (c) 2005 Camilla Berglund <elmindreda@elmindreda.org>
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any
// damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any
// purpose, including commercial applications, and to alter it and
// redistribute it freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you
//     must not claim that you wrote the original software. If you use
//     this software in a product, an acknowledgment in the product
//     documentation would be appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and
//     must not be misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//     distribution.
//
///////////////////////////////////////////////////////////////////////
#ifndef MOIRA_QUATERNION_H
#define MOIRA_QUATERNION_H
///////////////////////////////////////////////////////////////////////

#include <vector>

///////////////////////////////////////////////////////////////////////

namespace moira
{
  
///////////////////////////////////////////////////////////////////////

class Matrix3;

///////////////////////////////////////////////////////////////////////

class Quaternion
{
public:
  Quaternion(void);
  Quaternion(float sw, float sx, float sy, float sz);
  void invert(void);
  void normalize(void);
  void rotateVector(Vector3& vector) const;
  float dotProduct(const Quaternion& other) const;
  Quaternion interpolateTo(float t, const Quaternion& other) const;
  operator float* (void);
  operator const float* (void) const;
  Quaternion operator * (float value) const;
  Quaternion operator / (float value) const;
  Quaternion operator + (const Quaternion& quat) const;
  Quaternion operator * (const Quaternion& quat) const;
  Quaternion& operator += (const Quaternion& quat);
  Quaternion& operator *= (const Quaternion& quat);
  bool operator == (const Quaternion& quat) const;
  bool operator != (const Quaternion& quat) const;
  void set(float sw, float sx, float sy, float sz);
  void setDefaults(void);
  void setEulerRotation(const Vector3& angles);
  void setMatrixRotation(const Matrix3& matrix);
  void setVectorRotation(const Vector3& vector);
  void getAxisRotation(Vector3& axis, float& angle) const;
  void setAxisRotation(const Vector3& axis, float angle);
  float w;
  float x;
  float y;
  float z;
};

///////////////////////////////////////////////////////////////////////

class QuaternionTrack
{
public:
  typedef std::vector<Quaternion> PointList;
  void evaluate(float t, Quaternion& result) const;
  Quaternion operator () (float t) const;
  PointList points;
};

///////////////////////////////////////////////////////////////////////

} /*namespace moira*/

///////////////////////////////////////////////////////////////////////
#endif /*MOIRA_QUATERNION_H*/
///////////////////////////////////////////////////////////////////////
