///////////////////////////////////////////////////////////////////////
// Moira library
// Copyright (c) 2005 Camilla Berglund <elmindreda@elmindreda.org>
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any
// damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any
// purpose, including commercial applications, and to alter it and
// redistribute it freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you
//     must not claim that you wrote the original software. If you use
//     this software in a product, an acknowledgment in the product
//     documentation would be appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and
//     must not be misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//     distribution.
//
///////////////////////////////////////////////////////////////////////
#ifndef MOIRA_IMAGEGENERATORS_H
#define MOIRA_IMAGEGENERATORS_H
///////////////////////////////////////////////////////////////////////

namespace moira
{
  
///////////////////////////////////////////////////////////////////////

class BlobImageGenerator : public ImageGenerator
{
public:
  BlobImageGenerator(void);
  float getPenumbraRadius(void) const;
  void setPenumbraRadius(float newRadius);
  float getUmbraRadius(void) const;
  void setUmbraRadius(float newRadius);
  const ColorRGBA& getUmbraColor(void) const;
  void setUmbraColor(const ColorRGBA& newColor);
  float getExponent(void) const;
  void setExponent(float newExponent);
  Image* generate(const ImageFormat& format, unsigned int width, unsigned int height);
private:
  float umbraRadius;
  float penumbraRadius;
  ColorRGBA umbraColor;
  float exponent;
};

///////////////////////////////////////////////////////////////////////

class CheckerImageGenerator : public ImageGenerator
{
public:
  CheckerImageGenerator(void);
  const ColorRGBA& getCheckerColor(void) const;
  void setCheckerColor(const ColorRGBA& newColor);
  unsigned int getCheckerSize(void) const;
  void setCheckerSize(unsigned int newSize);
  Image* generate(const ImageFormat& format, unsigned int width, unsigned int height);
private:
  unsigned int checkerSize;
  ColorRGBA checkerColor;
};

///////////////////////////////////////////////////////////////////////

} /*namespace moira*/

///////////////////////////////////////////////////////////////////////
#endif /*MOIRA_IMAGEGENERATORS_H*/
///////////////////////////////////////////////////////////////////////
