
#include <moira/Moira.h>

using namespace moira;

int main(int argc, char** argv)
{
  BlobImageGenerator generator;
  generator.setUmbraRadius(0.25f);
  generator.setUmbraColor(ColorRGBA(1.f, 0.f, 0.5f, 1.f));
  generator.setDefaultColor(ColorRGBA(0.f, 0.f, 0.f, 0.f));
  generator.setExponent(3.f);

  Ref<Image> image = generator.generate(ImageFormat::RGBA8888, 256, 256);
  if (!image)
  {
    Log::writeError("Failed to generate image");
    exit(1);
  }

  if (!image->resize(512, 128))
  {
    Log::writeError("Failed to resample image");
    exit(1);
  }

  if (!image->crop(ImageArea(0, 0, 256, 64)))
  {
    Log::writeError("Failed to crop image");
    exit(1);
  }

  image->flipHorizontal();
  image->flipVertical();

  ImageCodecPNG codec;
  if (!codec.write(Path("image.png"), *image))
  {
    Log::writeError("Failed to write image");
    exit(1);
  }

  exit(0);
}

