uniform sampler2D colorMap;
uniform sampler2D alphaMap;
uniform sampler3D noiseMap;
 uniform float time;
 uniform float winterness;
 //uniform float gridness;

uniform vec4 lightPosition;

varying vec3 N;
varying vec3 v;

void main()
{

	
	vec3 L = vec3(2,1,0.5);
	normalize(L);   
	
	vec3 Norm =texture3D(noiseMap, vec3(gl_TexCoord[0].st*0.05,gl_TexCoord[0].s*0.13)).xyz*2.0-1.0;
	//gl_FragColor = vec4(N,1);
	float Idiff = max(dot(Norm,L), 0.0);
	
	Idiff = clamp(Idiff, 0.0, 1.0); 
	float mod = dot(texture3D(noiseMap, vec3(gl_TexCoord[0].st*10.0+winterness,0)+vec3(winterness,gl_TexCoord[0].st+vec2(0.2,0.6)))*2.0-1.0,
					texture3D(noiseMap, vec3(gl_TexCoord[0].st*-10.0-winterness,0))*2.0-1.0);
					
	vec4 color = mix(gl_FrontMaterial.diffuse,gl_FrontMaterial.ambient,winterness);				
	
    gl_FragColor = (Idiff+0.6+0.8*winterness)*texture2D(colorMap,gl_TexCoord[0].st+fract(mod)*vec2(0.2,0.6))*color;
	
	gl_FragColor.a= texture2D(alphaMap, gl_TexCoord[2].st).r;
	
	// gl_FragColor = vec4(texture2D(alphaMap, gl_TexCoord[2].st).rgb,0.5);
   
}