varying float depth;

uniform float focus;

uniform sampler2D colorMap;
uniform sampler2D alphaMap;

float clamp_far = 1.0; //must be between 0 and 1

void main()
{
	float f;

	float c = texture2D(colorMap, gl_TexCoord[0].st).r * texture2D(alphaMap, gl_TexCoord[0].st).r;
	float d = depth;
	
	if(d < focus) {
		f = (d - focus)/(focus - gl_DepthRange.near);
	}
	else {
		f = (d - focus)/( 300.0 - focus);
		//clamp the far blur to a maximum blurriness
		f = clamp(f, 0.0, clamp_far);
	}
	
	//f = f*c;
	
	//scale and bias into [0,1] range
	f = f * 0.5 + 0.5;

	gl_FragColor.rgb = vec3(f);
	gl_FragColor.a = c;//texture2D(alphaMap, gl_TexCoord[0].st).r;
	
}