/* Copyright (C) 2007  Mikko Sysikaski <mikko.sysikaski@gmail.com>
 * This program is free software distributed under GNU General Public License
 * version 3 or (at your option) any later version.
 * No warranty of any kind is provided. See the accompanying file COPYING for details.
 */

#ifndef PHYSICS_H
#define PHYSICS_H

#include "common.h"
#include "board.h"
#include "lcdcounter.h"

class LCD;

const float BALL_SIZE = 0.2f;
const float BLOCK_SIZE = 0.1f;
const float HOLE_SIZE = 0.35f;
const float MAX_ROT = 600.0f;

class Physics {
public:
	Physics();
	Physics(Board* board);
	void setBoard(Board* board);
	void resetBoard();

	enum UpdateState {
		NORMAL,
		DIE,
		WIN
	};
	UpdateState update(uint msec);
	void updateCounter();
	LCDCounter& getCounter() {
		return m_counter;
	}
	
	float setAngleX(float rot) {
		return m_rotX = clamp(rot, -MAX_ROT, MAX_ROT);
	}
	float setAngleY(float rot) {
		return m_rotY = clamp(rot, -MAX_ROT, MAX_ROT);
	}
	
	float getRotX() {
		return m_rotX;
	}
	float getRotY() {
		return m_rotY;
	}
	const Coord2& getPlace() {
		return m_place;
	}
	const float getHeight() {
		return m_height;
	}
	
private:
	LCDCounter m_counter;
	Board* m_board;
	Coord2 m_place;
	Coord2 m_speed;
	float m_rotX, m_rotY;
	float m_height;
	bool m_winning;

	void checkLimits();
	void checkHoles(float sec);
};

#endif
