#include "packhandler.h"
#include "gameloop.h"
#include "glscreen.h"
#include "sound.h"
#include <fstream>
#include <cstdio>

void PackHandler::load(const std::string& dir)
{
	std::string tmp = "levs/"+dir+"/";
	std::string file = tmp+"info.txt";
	std::ifstream in(file.c_str());
	if (!in.is_open()) {
		fprintf(stderr, "Warning: couldn't read level pack file %s\n", file.c_str());
		return;
	}
	char buf[1024];
	while(in) {
		if (!in.getline(buf, sizeof(buf)))
			break;
		if (!buf[0] || buf[0]=='#')
			continue;

		m_boards.push_back(tmp+std::string(buf));
	}
}

void PackHandler::exec()
{
	GameLoop::init();
	for(std::vector<std::string>::iterator i=m_boards.begin(); i!=m_boards.end(); ++i) {
		GameLoop game(i->c_str());
		if (!game.start(1))
			break;
	}
	GameLoop::deInit();
}
