#ifndef TEXGEN_H
#define TEXGEN_H

class NoiseGen {
public:
	NoiseGen(int xsize, int ysize);
	
	void newNoise();
	void newNoise(int x, int y);
	
	float turbulence(float x, float y, float a);
	float interpolate(float x, float y);
	float interpolate(float x, float y, int maxX, int maxY);
	
	float tile(float x, float y, float a);
	
	float getNoise(int x, int y) {
		return m_noise[y*m_xsize + x];
	}
	
private:
	
	float* m_noise;
	int m_xsize, m_ysize;
};

#endif
