/* Copyright (C) 2007  Mikko Sysikaski <mikko.sysikaski@gmail.com>
 * This program is free software distributed under GNU General Public License
 * version 3 or (at your option) any later version.
 * No warranty of any kind is provided. See the accompanying file COPYING for details.
 */

#ifndef ITEMPICKER_H
#define ITEMPICKER_H

#include "actionmenu.h"
#include "lcd.h"
#include "common.h"
#include "menubg.h"
#include <GL/gl.h>
#include <boost/algorithm/string/case_conv.hpp>

void SDL_GL_SwapBuffers();

/**
 * Base class for other than option menus.
 * Template parameter Derived is expected to implement
 * the following member functions:
 * - void setString(int num, std::string& str);
 * - std::string getTitle();
 * - bool pick(int num);
 */
template<class Derived>
class ItemPicker: public ActionMenu<ItemPicker<Derived> > {
public:
	typedef ActionMenu<ItemPicker<Derived> > Base;

	ItemPicker(): m_drawPlace(0) {}
	
	template<class Iter>
	ItemPicker(Iter begin, Iter end):
		ActionMenu<ItemPicker<Derived> >(begin, end),
		m_drawPlace(0)
		{}

	void draw() {
		const uint MAX_BOARDS = 14;
		
		glLoadIdentity();
		glClear(GL_COLOR_BUFFER_BIT);

		MenuBG::draw();
		
		glColor3f(1, 1, 0);
		glScalef(0.1, 0.1, 0.1);
		glTranslatef(-8, 8.5, 0);
		LCD::print(static_cast<Derived*>(this)->getTitle().c_str());
		glColor3f(0, 1, 0);
		if (Base::activeItem < m_drawPlace)
			m_drawPlace = Base::activeItem;
		else if (Base::activeItem-m_drawPlace > MAX_BOARDS) {
			m_drawPlace = Base::activeItem-MAX_BOARDS;
		}
		for(uint i=m_drawPlace; i<Base::items.size(); ++i) {
			glTranslatef(0, -1.2, 0);
			std::string tmp = Base::items[i];
			static_cast<Derived*>(this)->setString(i, tmp);
			boost::algorithm::to_lower(tmp);
			if (i == Base::activeItem) {
				glColor3f(0, 1, 1);
				glLineWidth(3);
				LCD::print(tmp.c_str());
				glColor3f(0, 1, 0);
				glLineWidth(1);
			}
			LCD::print(tmp.c_str());
		}
		
		SDL_GL_SwapBuffers();
	}
	bool pick(int num) {
		return static_cast<Derived*>(this)->pick(num);
	}
private:
	uint m_drawPlace;
};

#endif
