/* Copyright (C) 2007  Mikko Sysikaski <mikko.sysikaski@gmail.com>
 * This program is free software distributed under GNU General Public License
 * version 3 or (at your option) any later version.
 * No warranty of any kind is provided. See the accompanying file COPYING for details.
 */

#ifndef INGAMEMENU_H
#define INGAMEMENU_H

#include "actionmenu.h"

class BoardTimes;

class InGameMenu: public ActionMenu<InGameMenu> {
public:
	typedef ActionMenu<InGameMenu> Base;
	
	InGameMenu(bool running, bool nextOK, bool winState, int listPlace, BoardTimes* times):
			m_winning(winState), m_running(running), m_nextOK(nextOK),
			m_listPlace(listPlace), m_times(times)
	{
		if (m_running) {
			if (m_nextOK)
				m_listVec = &s_winRun;
			else
				m_listVec = &s_run;
		} else {
			if (m_nextOK)
				m_listVec = &s_winStop;
			else
				m_listVec = &s_stop;
		}
		items.swap(*m_listVec);
	}
	~InGameMenu()
	{
		items.swap(*m_listVec);
	}

	enum Action {
		CONTINUE,
		NEXT,
		RESET,
		QUIT
	};
	Action exec() {
		m_retVal = QUIT;
		Base::exec();
		return m_retVal;
	}
	
	void draw();
	
	bool pick(int num) {
		if (!m_running)
			++num;
		if (!m_nextOK && num >= 1)
			++num;

		m_retVal = Action(num);
		return 0;
	}

	typedef std::vector<std::string> StrVect;
private:
	Action m_retVal;
	bool m_winning;
	bool m_running;
	bool m_nextOK;
	int m_listPlace;
	BoardTimes* m_times;
	std::vector<std::string>* m_listVec;

	void drawTimes();
	void drawMenu();

	static StrVect s_run;
	static StrVect s_stop;
	static StrVect s_winRun;
	static StrVect s_winStop;
};

#endif
