/* Copyright (C) 2007  Mikko Sysikaski <mikko.sysikaski@gmail.com>
 * This program is free software distributed under GNU General Public License
 * version 3 or (at your option) any later version.
 * No warranty of any kind is provided. See the accompanying file COPYING for details.
 */

#ifndef GLSCREEN_H
#define GLSCREEN_H

#include <GL/gl.h>
#include <GL/glu.h>
#include "SDL.h"
#include "common.h"
#include <vector>

class Mutex2D;

class GLScreen {
public:
	static void init(int w, int h, bool fullscreen);
	static void init(bool fullscreen);

	static void resize(int w, int h, bool fullscreen=0);

	static void set2D();
	static void set3D();

	static int getResX() {
		return m_screen->w;
	}
	static int getResY() {
		return m_screen->h;
	}
	static bool isFullscreen() {
		return m_screen->flags & SDL_FULLSCREEN;
	}
	static bool updateRes(int index, bool fullscreen) {
		if (index < 0)
			return 0;
		const Coord<int>& mode = m_resolutions[index];
		if (mode.x != m_screen->w
				|| mode.y != m_screen->h
				|| fullscreen != bool(m_screen->flags&SDL_FULLSCREEN))
		{
			resize(int(mode.x), int(mode.y), fullscreen);
			return 1;
		}
		return 0;
	}
	static const std::vector<Coord<int> >& getOkRes()
	{
		return m_resolutions;
	}
	
private:
	static bool m_2D;
	static std::vector<Coord<int> > m_resolutions;
	
	static SDL_Surface* m_screen;

	static void doInit(int w, int h, bool fullscreen);

	GLScreen() {}
};

class Mutex2D {
public:
	Mutex2D() {
		if (!used++) {
			glMatrixMode(GL_PROJECTION);
			glPushMatrix();
			glLoadIdentity();
			glMatrixMode(GL_MODELVIEW);
		}
	}
	~Mutex2D() {
		if (!--used) {
			glMatrixMode(GL_PROJECTION);
			glPopMatrix();
			glMatrixMode(GL_MODELVIEW);
		}
	}

private:
	static int used;
};

#endif
