/* Copyright (C) 2007  Mikko Sysikaski <mikko.sysikaski@gmail.com>
 * This program is free software distributed under GNU General Public License
 * version 3 or (at your option) any later version.
 * No warranty of any kind is provided. See the accompanying file COPYING for details.
 */

#ifndef GAMEAPP_H
#define GAMEAPP_H

class Board;
class Physics;
class Renderer;
class EventHandler;
class MainMenu;
class Options;

class GameApp {
public:
	void init(int argc, char* argv[]);
//	GameApp(int argc, char* argv[]);
	
	void start();
	
	static GameApp& getInstance() {
		return m_instance;
	}
	Renderer& getRenderer() {
		return *m_renderer;
	}
	Physics& getPhysics() {
		return *m_physics;
	}
	EventHandler& getEventHandler() {
		return *m_events;
	}
	Options& getOptions() {
		return *m_options;
	}
	
private:
	void readParams(int argc, char* argv[]);
	void initVideo();

	MainMenu* m_menu;
	Renderer* m_renderer;
	Physics* m_physics;
	EventHandler* m_events;
	Options* m_options;

	static GameApp m_instance;
};

#endif
