/* Copyright (C) 2007  Mikko Sysikaski <mikko.sysikaski@gmail.com>
 * This program is free software distributed under GNU General Public License
 * version 3 or (at your option) any later version.
 * No warranty of any kind is provided. See the accompanying file COPYING for details.
 */

#ifndef MODIFIABLEBOARD_H
#define MODIFIABLEBOARD_H

#include "../board.h"

class ModifiableBoard: public Board {
public:
	enum WallT {
		DOWN, LEFT, BSLASH, SLASH
	};
	void toggleWall(int y, int x, WallT type) {
		m_board[y*m_x + x] ^= 1<<int(type);
	}
	void setBlock(int y, int x, BlockT b) {
		m_blocks[y*m_x + x] = b;
	}
	void setTime(int t) {
		m_minTime = t;
	}
	void save(const char* filename);
	void create(int h, int w);
	
	void insertRows(int place, int amount);
	void insertColumns(int place, int amount);
	void deleteRows(int place, int amount);
	void deleteColumns(int place, int amount);
};

#endif
