/* Copyright (C) 2007  Mikko Sysikaski <mikko.sysikaski@gmail.com>
 * This program is free software distributed under GNU General Public License
 * version 3 or (at your option) any later version.
 * No warranty of any kind is provided. See the accompanying file COPYING for details.
 */

#include "dialog.h"
#include "drawer.h"
#include "SDL_ttf.h"
#include <boost/lexical_cast.hpp>
#include <cctype>

TTF_Font* font;

void startDialog(const char* file, int size)
{
	TTF_Init();
	font = TTF_OpenFont(file, size);
	if (!font) {
		fprintf(stderr, "Error: couldn't read font %s\n", file);
		SDL_Quit();
		exit(1);
	}
}

void endDialog()
{
	TTF_Quit();
}

namespace {
SDL_Color fg = {0, 0, 0};
SDL_Color bg = {0xf, 0xcc, 0xf};
};

bool savePath(std::string& res, const Board& b, int xplace, int yplace, int pps)
{
	SDL_Surface* title = TTF_RenderUTF8_Shaded(font, "Give file name:", fg, bg);
	int height = TTF_FontHeight(font);

	SDL_Event e;
	SDL_Rect rect = {0, 0, title->w, height*2};
	SDL_Surface* screen = getScreen();
	SDL_Rect textRect = {0, height, 0, height};

	bool retval = 1;
	while(1) {
		draw(b, xplace, yplace, pps);
		SDL_FillRect(screen, &rect, SDL_MapRGB(screen->format, bg.r, bg.g, bg.b));
		SDL_BlitSurface(title, 0, screen, 0);
		if (!res.empty()) {
			SDL_Surface* text = TTF_RenderUTF8_Shaded(font, res.c_str(), fg, bg);
			textRect.w = text->w;
			SDL_BlitSurface(text, 0, screen, &textRect);
			SDL_FreeSurface(text);
		}
		endDraw();

		SDL_WaitEvent(&e);
	handle_event:
		if (e.type == SDL_QUIT) {
			TTF_Quit();
			SDL_Quit();
		} else if (e.type == SDL_KEYDOWN) {
			int key = e.key.keysym.sym;
			if (key == SDLK_ESCAPE) {
				retval = 0;
				break;
			} else if (key == SDLK_BACKSPACE) {
				if (res.size() > 0)
					res.erase(res.end()-1, res.end());
			} else if (key == SDLK_RETURN) {
				break;
			} else {
				res.push_back(key);
			}
		}

		if (SDL_PollEvent(&e))
			goto handle_event;
	}
	SDL_FreeSurface(title);

	return retval;
}

int askTime(int old, const Board& b, int xplace, int yplace, int pps)
{
	SDL_Surface* title = TTF_RenderUTF8_Shaded(font, "Give min time:", fg, bg);
	int height = TTF_FontHeight(font);
	std::string str;
	if (old >= 0)
		str = boost::lexical_cast<std::string>(old);
	SDL_Rect rect = {0, 0, title->w, height*2};
	SDL_Surface* screen = getScreen();
	SDL_Rect textRect = {0, height, 0, height};

	SDL_Event e;
	while(1) {
		draw(b, xplace, yplace, pps);
		SDL_FillRect(screen, &rect, SDL_MapRGB(screen->format, bg.r, bg.g, bg.b));
		SDL_BlitSurface(title, 0, screen, 0);
		if (!str.empty()) {
			SDL_Surface* text = TTF_RenderUTF8_Shaded(font, str.c_str(), fg, bg);
			textRect.w = text->w;
			SDL_BlitSurface(text, 0, screen, &textRect);
			SDL_FreeSurface(text);
		}
		endDraw();

		SDL_WaitEvent(&e);
	handle_event:
			if (e.type == SDL_QUIT) {
				TTF_Quit();
				SDL_Quit();
			} else if (e.type == SDL_KEYDOWN) {
				int key = e.key.keysym.sym;
				if (key == SDLK_ESCAPE) {
					break;
				} else if (key == SDLK_BACKSPACE) {
					if (str.size() > 0)
						str.erase(str.end()-1, str.end());
				} else if (key == SDLK_RETURN) {
					break;
				} else if (isdigit(key)) {
					str.push_back(key);
				}
			}

			if (SDL_PollEvent(&e))
				goto handle_event;
	}
	SDL_FreeSurface(title);

	if (str.empty())
		return -1;
	return boost::lexical_cast<int>(str);
}
