/* Copyright (C) 2007  Mikko Sysikaski <mikko.sysikaski@gmail.com>
 * This program is free software distributed under GNU General Public License
 * version 3 or (at your option) any later version.
 * No warranty of any kind is provided. See the accompanying file COPYING for details.
 */

#ifndef COMMON_H
#define COMMON_H

typedef unsigned int uint;

template<class T> inline
T clamp(T value, T min, T max)
{
	if (value < min)
		return min;
	else if (value > max)
		return max;
	return value;
}

template<class T>
struct Coord {
	T x, y;
	
	Coord() {}
	Coord(T a, T b):
			x(a), y(b)
			{}

	bool operator==(const Coord<T>& c) const {
		return x==c.x && y==c.y;
	}
};
typedef Coord<float> Coord2;

/** Modulo function that works as it should be in
 * math instead of the standard CPU functionality.
 */
template<class Int> inline
Int mod(Int a, Int b) {
	Int res = a%b;
	if (res < static_cast<Int>(0))
		res += b;
	return res;
}

#endif
