/* Copyright (C) 2007  Mikko Sysikaski <mikko.sysikaski@gmail.com>
 * This program is free software distributed under GNU General Public License
 * version 3 or (at your option) any later version.
 * No warranty of any kind is provided. See the accompanying file COPYING for details.
 */

#ifndef ACTIONMENU_H
#define ACTIONMENU_H

#include <vector>
#include <string>
#include "SDL.h"
#include <cstdlib>
#include <cstdio>
#include "menubase.h"

/**
 * Base class for other than option menus.
 * Template parameter Derived is expected to implement
 * the following member functions:
 * - void draw();
 * - bool pick(int itemNum); // the menu will quit if returns false
 */
template<class Derived>
class ActionMenu:
	public MenuBase<ActionMenu<Derived>, std::string>
{
public:
	typedef MenuBase<ActionMenu<Derived>, std::string> Base;
	
	ActionMenu() {}

	template<class Iter>
	ActionMenu(Iter begin, Iter end):
		Base(begin, end)
		{}

	bool processKey(SDLKey key) {
		if (key == SDLK_RETURN || key == SDLK_SPACE)
			return static_cast<Derived*>(this)->pick(Base::activeItem);
		return 1;
	}
	void draw() {
		static_cast<Derived*>(this)->draw();
	}
};

#endif
