--- objective ---------------------------------------------------------
--
--    survive for 45 seconds without falling
--
-----------------------------------------------------------------------

app = GetApplication();
space = app:GetSpace();
level = GetLevel();

app:SetBgImage("res\\sky2.png");
app:SetQueryUpdate(false);

AddObjective("survive for 45 seconds without falling");

-- create some blue clouds
space:Insert(CreateCloud("res\\cloud.png", 0.0, 0.2, 0, 0.1, 0.2));
space:Insert(CreateCloud("res\\cloud.png", 0.0, -0.2, 0, 0.1, 0.3));

-- set level time to 45 seconds. level is completed if
-- the player is still alive when the time is up
SetLevelTime(45);
RegisterTimeUpEvent("SetVariable(\"timeup\");");
level:Add(CreateVariableCondition("timeup"));

-- set bike position
bike = GetBike();
bike:MoveTo(200, 400);

-- create the rotating block
block = CreateBlock(100, 500, 970, 30, "res\\rotating_block1.png", true);
block:SetMass(1.0);
AnchorCenter(block);
AddMotor(block, 0.015);
space:Insert(block);

-- set up events
-- end level if the player falls
driver = space:FindObject("driver");
EventYGreater(driver, 1500, "RestartLevel();");

-- add sprites on top of the background image to make the sun more alive
sun = CreateSprite("res\\rayofsun.png", 4, 128, 128, 16, 190.00, 0, 422, true);
sun:SetStatic(true);
space:Insert(sun);
sun = CreateSprite("res\\rayofsun.png", 4, 128, 128, 16, 300.00, 50, 472, true);
sun:SetStatic(true);
space:Insert(sun);
sun = CreateSprite("res\\rayofsun.png", 4, 128, 128, 16, 150.00, 0, 472, true);
sun:SetStatic(true);
space:Insert(sun);





