float4x4 g_mWorld;
float4x4 g_mWorldViewProj;

texture g_tTex;

float4 g_f4Col;

sampler Sampler = sampler_state {
    Texture   = (g_tTex);
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

void VSFront(		float4 Position : POSITION, float3 Normal : NORMAL,  float2 UV : TEXCOORD0,
					out float4 oPosition : POSITION, out float4 oCol : COLOR0, out float2 oUV : TEXCOORD0) 
{
	oPosition=mul(Position, g_mWorldViewProj);
	
	float3 n=normalize(mul(-Normal, (float3x3)g_mWorld));
	
	oCol=dot(n, float3(0, 0, 1))*g_f4Col;
	oUV=UV;
}

void VSBack(		float4 Position : POSITION, float3 Normal : NORMAL,  float2 UV : TEXCOORD0,
					out float4 oPosition : POSITION, out float4 oCol : COLOR0, out float2 oUV : TEXCOORD0) 
{
	oPosition=mul(Position, g_mWorldViewProj);
	
	float3 n=-normalize(mul(-Normal, (float3x3)g_mWorld));
	
	oCol=dot(n, float3(0, 0, 1))*g_f4Col;
	oUV=UV;
}



float4 PS(float2 UV : TEXCOORD0, float4 col : COLOR0) : COLOR
{
	return col*tex2D(Sampler, UV);
}

technique Front {
	pass P0 {
		CullMode = CCW;
		VertexShader = compile vs_1_1 VSFront();
		PixelShader = compile ps_2_0 PS();
	}
}

technique Back {
	pass P0 {
		CullMode = CW;
		VertexShader = compile vs_1_1 VSBack();
		PixelShader = compile ps_2_0 PS();
	}
}