vec4 = {};

vec4.mt = {}; --metatable

function vec4.new(a, b, c, d)
	local v = {x=a, y=b, z=c, w=d};
	setmetatable(v, vec4.mt);
	return v;
end

function vec4.add(a, b)
	return vec4.new(a.x+b.x, a.y+b.y, a.z+b.z, a.w+b.w);
end

function vec4.sub(a, b)
	return vec4.new(a.x-b.x, a.y-b.y, a.z-b.z, a.w-b.w);
end

function vec4.negate(a)
	a.x=-a.x; a.y=-a.y; a.z=-a.z; a.w=-a.w;
end

function vec4.negated(a)
	return vec4.new(-a.x, -a.y, -a.z, -a.w);
end
	
function vec4.mul(a, b)
    if( type(a) == "number" ) then
        return vec4.new(a*b.x, a*b.y, a*b.z, a*b.w)
    elseif( type(b) == "number" ) then
        return vec4.new(b*a.x, b*a.y, b*a.z)
    else
        return vec4.new(a.x*b.x, a.y*b.y, a.z*b.z, a.w*b.w)
    end
end

function vec4.div(a, b)
	local r=1/b
	return vec4.new(a.x*r, a.y*r, a.z*r, a.w*r);
end

function vec4.dot(a, b)
	return a.x*b.x+a.y*b.y+a.z*b.z+a.w*b.w;
end

function vec4.lengthsq(a)
	return a.x*a.x+a.y*a.y+a.z*a.z+a.w*b.w;
end

function vec4.length(a)
	return math.sqrt(vec4.lengthsq(a));
end

function vec4.normalize(a)
	local l=vec4.length(a);
	a.x=a.x/l; a.y=a.y/l; a.z=a.z/l; a.w=a.w/l;
end

function vec4.normalized(a)
	local l=vec4.length(a);
	return vec4.new(a.x/l, a.y/l, a.z/l, a.w/l);
end

vec4.mt.__add=vec4.add;
vec4.mt.__sub=vec4.sub;
vec4.mt.__unm=vec4.negate;
vec4.mt.__mul=vec4.mul;
vec4.mt.__div=vec4.div;