vec3 = {};

vec3.mt = {}; --metatable

function vec3.new(a, b, c)
	local v = {x=a, y=b, z=c};
	setmetatable(v, vec3.mt);
	return v;
end

function vec3.add(a, b)
	return vec3.new(a.x+b.x, a.y+b.y, a.z+b.z);
end

function vec3.sub(a, b)
	return vec3.new(a.x-b.x, a.y-b.y, a.z-b.z);
end

function vec3.negate(a)
	return vec3.new(-a.x, -a.y, -a.z);
end
	
function vec3.mul(a, b)
    if( type(a) == "number" ) then
        return vec3.new(a*b.x, a*b.y, a*b.z)
    elseif( type(b) == "number" ) then
        return vec3.new(b*a.x, b*a.y, b*a.z)
    else
        return vec3.new(a.x*b.x, a.y*b.y, a.z*b.z)
    end
end

function vec3.div(a, b)
	local r=1/b
	return vec3.new(a.x*r, a.y*r, a.z*r);
end

function vec3.dot(a, b)
	return a.x*b.x+a.y*b.y+a.z*b.z;
end

function vec3.cross(a, b)
	return vec3.new(a.y*b.z-a.z*b.y, a.z*b.x-a.x*b.z, a.x*b.y-a.y-b.x);
end

function vec3.lengthsq(a)
	return a.x*a.x+a.y*a.y+a.z*a.z;
end

function vec3.length(a)
	return math.sqrt(vec3.lengthsq(a));
end

function vec3.normalize(a)
	local l=vec3.length(a);
	a.x=a.x/l; a.y=a.y/l; a.z=a.z/l;
end

function vec3.normalized(a)
	local l=vec3.length(a);
	return vec3.new(a.x/l, a.y/l, a.z/l);
end

vec3.mt.__add=vec3.add;
vec3.mt.__sub=vec3.sub;
vec3.mt.__unm=vec3.negate;
vec3.mt.__mul=vec3.mul;
vec3.mt.__div=vec3.div;