

// Note: rotation in degrees
uniform float magnification;
uniform float rotation;
uniform float xCenter;
uniform float yCenter;

// Calculates a coordinate transform specified by the uniform parameters.
// The vertices are assumed to be located in the corners of the rectangle
// [-aspect, aspect] x [-1, 1].

void main()
{
	// Calculate rotation
	float theta = radians(rotation);
	float cosTheta = cos(theta), sinTheta = sin(theta);
	
	
	// Rotate	
	float x0 = gl_Vertex.x + xCenter;
	float y0 = gl_Vertex.y + yCenter;

	float x = cosTheta * x0 - sinTheta * y0;
	float y = sinTheta * x0 + cosTheta * y0;
	
	// Scale
	x = x / magnification;
	y = y / magnification;
	
	// Translate center to origin
	gl_TexCoord[0] = vec4(x, y, 0.0, 0.0);

	// Keep the vertices unchanged
	gl_Position = gl_ModelViewMatrix * gl_Vertex;
}
