uniform float xDistortion;
uniform float yDistortion;

uniform sampler1D palette;
uniform float paletteOffset;
uniform float paletteScale;
uniform float xTrap;
uniform float yTrap;

void main()
{
	// ----------------------------- Boogiebrot iteration initialization start ---
	const int maxIter = 45;
	const float bailout = 1.0e4;
	int numIter = 0;

	// Initial position
	vec2 z = gl_TexCoord[0].xy, zPrevious;
	vec2 pixel = z;

	// Bailout flag
	bool isInside = true;
	float distance;
	// ----------------------------- Boogiebrot iteration initialization end -----

	vec2 center = vec2(xTrap, yTrap);
	
	float minDistance = 1.0e5;
	
	// Iterate
	while ((isInside) && (numIter < maxIter))
	{
		// ------------------------- Boogiebrot iteration start -----
		float A = z.x*z.x - z.y*z.y;
		float B = 2.0*z.x*z.y;
		float C = 1.0 + z.x*xDistortion - z.y*yDistortion;
		float D = z.x*yDistortion + z.y*xDistortion;
		
		// Nominator vector
		vec2 AB = vec2(A, B);
		// Denominator vector
		vec2 CD = vec2(C, D);

		// Iterate the formula z(n+1) = z(n)^2 / (1 + d*z) + C
		z = vec2(dot(AB, CD), B*C - A*D) / (dot(CD,CD)) + pixel;
		
		distance = length(z);

		// Test bailout
		isInside = (distance > bailout) ? false : true;
		
		// Next iteration		
		numIter++;
		// ------------------------- Boogiebrot iteration end -------

		
		// Find minimum distance
		if (minDistance > distance)
		{
			minDistance = distance;
		}
	}

	// Outside coloring
	gl_FragColor = texture1D(palette, paletteScale * sqrt(minDistance) + paletteOffset);
}

