uniform float distortionReal;
uniform float distortionImag;
uniform float textureScale;

uniform sampler1D paletteOutside;
uniform sampler2D image;

void main()
{
	const int firstTrap = 2;
	const int lastTrap = 6;
	const int maxIter = 45;
	const float bailout = 1.0e4;
	int numIter = 0;

	// Initial position
	vec2 z = gl_TexCoord[0].xy, zPrevious;
	vec2 pixel = z;

	// Bailout flag
	bool isInside = true;
	vec4 colorAvr = vec4(0,0,0,0), colorAvrPrevious;
	
	// Iterate
	while ((isInside) && (numIter < maxIter))
	{
		float A = z.x*z.x - z.y*z.y;
		float B = 2.0*z.x*z.y;
		float C = 1.0 + z.x*distortionReal - z.y*distortionImag;
		float D = z.x*distortionImag + z.y*distortionReal;
		
		// Nominator vector
		vec2 AB = vec2(A, B);
		// Denominator vector
		vec2 CD = vec2(C, D);
		
		// Iterate the formula z(n+1) = z(n)^2 / (1 + d*z) + C
		zPrevious = z;
		z = vec2(dot(AB, CD), B*C - A*D) / (dot(CD,CD)) + pixel;
		
		numIter++;
		

		//colorAvrPrevious = colorAvr;
		colorAvr = ((firstTrap <= numIter) && (numIter <= lastTrap)) ?
			colorAvr + texture2D(image, textureScale * z)) : (colorAvr);
		
		//colorAvr = colorAvr + texture2D(image, textureScale * z);
		
		if (length(z) > bailout)
		{
			// Bailout
			isInside = false;
		}
		

	}

	// Estimate rate of divergence	
	float power = log(length(z)) / log(length(zPrevious));

	// Calculate the decimal part of the smooth iteration count
	float smoothDecimal =  log(log(bailout) / log(length(z))) / log(power);

	
	//float numTrappedIter = max(1.0, min(float(lastTrap),float(numIter)) - float(firstTrap + 1));

	// Interpolate using decimal part
	colorAvr = smoothDecimal * colorAvr / (numIter + 1)
		+ (1 - smoothDecimal) * colorAvrPrevious / numIter;

	// Inside coloring
	if (isInside)
	{
		colorAvr = vec4(1, 0.8, 0.4, 1);// * vec4(colorAvr.rgb, 1);
	}

	// Outside coloring
	

	gl_FragColor = colorAvr;//vec4(colorAvr.rgb / numTrappedIterations, 1);
}


/*
	// Calculate smooth iteration count
	float d = float(numIter) 
		+ log(log(bailout) / log(length(z))) / log(2.0);

	// Calculate index
	d = 0.5 + 0.5*sin(sqrt(d));
	
	//gl_FragColor = vec4(0.2 + 0.8*d, 0.8*d, 0.6*d + 0.1, 1);
	vec4 color;
	if (isInside) //|| (numIter < 4))
	{
		// Modify inside color
		color = texture1D(paletteOutside, 0.1 * float(numIter));
	}
	else
	{
		color = texture2D(image, textureScale * zTrapped);
	}
	//vec4 partColor = 0.9;// + 0.5*texture1D(paletteOutside, d);
	gl_FragColor = texture2D(image, textureScale * zTrapped);// + 0.5*texture1D(paletteOutside, d);
	//gl_FragColor = vec4(0,1,0,1);
}
*/
