#include "sgonode.h"

sgoNode::sgoNode()
{
	anim	= NULL;
}

void sgoNode::loadNode(FileHolder &fh)
{
	node_type = fh.readByte();

	switch (node_type)
	{
	case sgoNode::nodeType::MESH:
		object = new sgoMesh;
		object ->loadObject(fh);
		break;

	case sgoNode::nodeType::HELPER:
		object = new sgoHelper;
		object ->loadObject(fh);
		break;
	}

	anim = new sgoAnim;
	anim ->loadAnim(fh);

	c_child_nodes = fh.readWord();
	child_nodes = new sgoNode[c_child_nodes];

	for (int i = 0; i < c_child_nodes; i++)
	{
		child_nodes[i].loadNode(fh);
	}
}

void sgoNode::renderNode(float time)
{
	if (anim)
	{
		glPushMatrix();
		anim ->setMatrix(time);
	}

	if (node_type == nodeType::MESH) ((sgoMesh *)object) ->renderMesh();

	for (int i = 0; i < c_child_nodes; i++)
	{
		child_nodes[i].renderNode(time);
	}

	if (anim) glPopMatrix();
}

void sgoNode::buildList()
{
	if (node_type == nodeType::MESH)
		((sgoMesh *)object) ->buildList();

	for (int i = 0; i < c_child_nodes; i++)
	{
		child_nodes[i].buildList();
	}
}