#include "camera.h"

CAMERA::CAMERA()
{
	pos(0, 0, 0);

	vert	= 0.0f;
	hori	= 0.0f;
	roll	= 0.0f;
}

void CAMERA::SetCamera()
{
	glRotatef(roll, 0.0f, 0.0f, 1.0f);
	glRotatef(vert, 1.0f, 0.0f, 0.0f);
	glRotatef(hori, 0.0f, 1.0f, 0.0f);

	glTranslatef(-pos.x, -pos.y, -pos.z);
}

void CAMERA::LookAt(float _x, float _y, float _z)
{
	G3DVECTOR	target, v, minus_check;

	target(_x, _y, _z);
	target = target - pos;
	target.y = 0.0f;
	target.Normalize();

	v(0.0f, 0.0f, -1.0f);
	minus_check(1.0f, 0.0f, 0.0);

	hori = v.DotProduct(target);
	if (hori > 1.0f) hori = 1.0f;
	if (hori < -1.0f) hori = -1.0f;
	hori = deg(acosf(hori));
	if (minus_check.DotProduct(target) < 0.0f) hori = -hori;

	target(_x, _y, _z);
	target = target - pos;
	target.Normalize();
	v = target;

	v.y = 0.0f;
	v.Normalize();
	minus_check(0.0f, -1.0f, 0.0);

	vert = v.DotProduct(target);
	if (vert > 1.0f) vert = 1.0f;
	if (vert < -1.0f) vert = -1.0f;
	vert = deg(acosf(vert));
	if (minus_check.DotProduct(target) < 0.0f) vert = -vert;
}

G3DVECTOR CAMERA::GetTarget()
{
	G3DVECTOR	target;
	target(0.0f, 0.0f, -1.0f);
	target.RotateX(-rad(vert));
	target.RotateY(rad(hori));
	return target;
}