//
// Hemisphere Lighting Model
// Copyright (c) Microsoft Corporation. All rights reserved.
//
// Note: This effect file works with EffectEdit.
//


string XFile = "\\code\\oma\\c#\\mozz\\valmis\\data\\testipallo.x";          // model
int    BCLR  = 0xff202080;                  // background

float time : TIME;
float spherify = 0.5;
float teema = 60;

// transformations
//float4x3 WorldView  : WORLDVIEW;
float4x4 Projection : PROJECTION;
float4x4 World : WORLD;
float4x4 View : VIEW;

struct VS_OUTPUT
{
    float4 Pos  : POSITION;
    float4 Diff : COLOR0;
//    float4 Spec : COLOR1;
};

VS_OUTPUT VS(
    float4 Pos  : POSITION,
	float4 Norm : NORMAL,
	uniform float mul1,
	uniform float mul2
//    float  Occ  : TEXCOORD0
    )
{
    VS_OUTPUT Out;// = (VS_OUTPUT)0;


    // spherify
    float4 p = Pos;
    p = normalize(p);
    p*= mul2;
    p.w = Pos.w;
    p = lerp( p, Pos, spherify );
/**/

    
    float dis = length( p );
    
    float d2 = (1/dis) * 3.14156;

    float2 p1 = float2( p.x, p.y );
    float d1 = length( p1 );
    float a1 = atan2( p1.x, p1.y );

    a1+=(d2 * 43) * sin( time * 1.6 * mul1 );

    p.x = d1 * sin( a1 );
    p.y = d1 * cos( a1 );

    p1 = float2( p.x, p.z );
    d1 = length( p1 );

    a1 = atan2( p1.x, p1.y );

    a1+=(d2 * 33 ) * cos( time  * mul1 );

    p.x = d1 * sin( a1 );
    p.z = d1 * cos( a1 );


    float4 posProj = mul( p, World );
    posProj = mul( posProj, View );
    posProj = mul( posProj, Projection );

    Out.Pos  = posProj;

	float3 SurfColor = {1,.9,.8};
    float3 Lvec = (SurfColor - normalize( p ));
	Lvec = pow( Lvec, 3 ) / 6;
    float ldn = abs(dot( Lvec, Norm.yzx ));

    Out.Diff = float4((ldn*SurfColor),0.1);

    return Out;
}



technique PASKA
{
	pass P0
	{
      	VertexShader = compile vs_2_0 VS(1, 120);

		PixelShader = null;
		ZWriteEnable = true;
		ZEnable = true;
		ZFunc = LessEqual;


		AlphaBlendEnable = FALSE;
	

		SpecularEnable = TRUE;
		CullMode = none;
    }
}

technique minifix
{
	pass P0
	{
      	VertexShader = compile vs_2_0 VS( 0.2, teema );

		PixelShader = null;
		ZWriteEnable = true;
		ZEnable = true;
		ZFunc = LessEqual;


		AlphaBlendEnable = FALSE;
	

		SpecularEnable = TRUE;
		CullMode = none;
    }
}



