
//texture tex0 < string name = "tiger\\tiger.bmp"; >;
texture tex0 < string name = "\\texture\\cc_alas.jpg"; >;

float3 lightDir
<
    string UIDirectional = "Light Direction";
> = {0.577, -0.577, 0.577};


float3 ballPos = { 0, 0, 5 };
float4x4 WorldViewProj : WorldViewProjection;

float time : TIME;

string XFile = "\\code\\oma\\c#\\mozz\\valmis\\data\\plane.x";   // Model to load
string BIMG  = "misc\\lake.bmp";  // Background image
DWORD  BCLR = 0xff202080;  // Background color (if no image)



struct VS_OUTPUT
{
    float4 Pos  : POSITION;
    float4 col    : Color0;
    float2 tex  : TEXCOORD0;
};

VS_OUTPUT VS(
    float3 pos : POSITION,
    float4 norm: NORMAL,
    float4 col : Color0
//    float2 tex  : TEXCOORD0
    ) 
{
    VS_OUTPUT Out;

    float dis = distance( pos, ballPos );

    float3 posi = pos;

    float voima;

    float dis_mul = clamp( (dis/20)-0.5, 0, 3.1415 );
    voima = sin( dis_mul );

    voima = voima *4;

    voima *=  (8/dis)*sin(-time*15+dis/6);

    posi.z = voima;

    Out.Pos = mul(float4(posi, 1.0f), WorldViewProj);

    voima = (1+voima) / 2;
    Out.col = float4(voima,voima,voima,1);

//    Out.col = float4(1,1,1,1);

    float3 kof = float3( 0,0,Out.Pos.z );
//    Out.col *= dot( kof, float3(0,0,1) );

    float2 tex = float2(1,1);
//    norm = norm * Out.Pos;
    tex = dot(norm,Out.Pos) * voima / 300;

//    tex = float2(1,1);

//    tex.x = Out.Pos.z * WorldViewProj;
    Out.tex = tex;

    return Out;
}


technique tec0
{
    pass p0
    {
      VertexShader = compile vs_2_0 VS();
        // Set up reasonable material defaults
        MaterialAmbient = {0.0, 0.0, 0.0, 0.0}; 
        MaterialDiffuse = {1.0, 1.0, 1.0, 1.0}; 
        MaterialSpecular = {1.0, 1.0, 1.0, 1.0}; 
        MaterialPower = 40.0f;
        
        // Set up one directional light
        LightType[0]      = DIRECTIONAL;
        LightDiffuse[0]   = {1.0, 1.0, 1.0, 1.0};
        LightSpecular[0]  = {1.0, 1.0, 1.0, 1.0}; 
        LightAmbient[0]   = {0.1, 0.1, 0.1, 1.0};
        LightDirection[0] = <lightDir>; // Use the vector parameter defined above
        LightRange[0]     = 1000.0;
        
        // Turn lighting on and use light 0
        LightEnable[0] = True;
        Lighting = True;
        SpecularEnable = True;
        CullMode = none   ;
        
        // Set up texture stage 0
        Texture[0] = <tex0>; // Use the texture parameter defined above
        ColorOp[0] = Modulate;
        ColorArg1[0] = Texture;
        ColorArg2[0] = Diffuse;
        AlphaOp[0] = Modulate;
        AlphaArg1[0] = Texture;
        AlphaArg2[0] = Diffuse;
        MinFilter[0] = Linear;
        MagFilter[0] = Linear;
        MipFilter[0] = Linear;
        
        // Disable texture stage 1
        ColorOp[1] = Disable;
        AlphaOp[1] = Disable;
    }
}
