;******************************************************************************
; beams.asm
; 2006/11/05
; Martin Veilleux
;******************************************************************************
;==============================================================================
; INCLUDES
;==============================================================================
;==============================================================================
; DEFINITIONS
;==============================================================================
%assign MAX_TRAILS 8
%assign TRAILF_ADD 0x01
%assign TRAILF_RENDER 0x02
%assign TRAILF_UPDATE 0x04
;==============================================================================
; MACROS
;==============================================================================
;==============================================================================
section .data
;==============================================================================
beamCamMinRad: dd 40.0
beamCamAmpl: dd 15.0
        
gpos1: dd -90.0, -14.0, 0
gpos2: dd 0, -14.0, -90.0
gpos3: dd -90.0, 14.0, 0
gpos4: dd 0, 14.0, -90.0
gridStride: dd 10.0
beamdiam: dd 2.0
beamlen: dd 180.0

beamsTrailDat:
dd 5152,4605,79.0,PACKB2DW(0,240,128,128),12.0
dd 4002,3405,121.0,PACKB2DW(0,128,240,128),13.0
dd 3487,2689,117.0,PACKB2DW(0,128,128,240),14.0
dd 4725,5806,21.0,PACKB2DW(0,240,128,240),15.0
dd 4555,4185,74.0,PACKB2DW(0,240,240,128),12.0
dd 3989,2978,129.0,PACKB2DW(0,128,240,240),13.0
dd 3342,6245,110.0,PACKB2DW(0,240,210,128),14.0
dd 3682,4762,167.0,PACKB2DW(0,128,210,240),15.0

harmonicScale: dd 4.0,4.0,4.0
shMin: dd 2.01
shAmpl: dd 1.0
gharmX: dd 1.0,4,1.0,2
gharmY: dd 1.0,4,1.0,2 ;updated before rendering

;==============================================================================
section .bss
;==============================================================================
gTrail: resd 1

;==============================================================================
section .text
;==============================================================================
SDECL _initBeams, 0
;==============================================================================
    MemAlloc trail_size*MAX_TRAILS
    mov     dword[gTrail],eax
    CCALL   _initObject
.exit:
DECLEND
;==============================================================================
SDECL _initObject, 0
;==============================================================================
    MPUSH   ebp
    LCTX    ebp
    LVAR    4, ptrail, count, pdat
    LENTER
    mov     eax,dword[gTrail]
    mov     dword[%$ptrail],eax
    mov     dword[%$pdat],beamsTrailDat
    mov     dword[%$count],MAX_TRAILS
.iterTrail:
    CCALL   _TRAIL_init, [%$ptrail], 128, 500
    mov     edi,dword[%$ptrail]
    mov     dword[edi +trail.tex],gtexFlare1d
    mov     dword[edi +trail.flaretex],gtexFlare
    mov     esi,dword[%$pdat]
    rgbaUnpack edi +trail.c, [esi +12]
;next
    add     dword[%$ptrail],trail_size
    add     dword[%$pdat],20
    dec     dword[%$count]
    jnz     .iterTrail

.exit:
    LEXIT
    MPOP    ebp
DECLEND
;==============================================================================
SDECL _updateBeams, 0
;==============================================================================
    CCALL   _FN_sin, [RTM_time], [shMin], [shAmpl], [greal2000pi], 15287, 0
    fstp    dword[gharmY +sharm.freq1]
    CCALL   _FN_sin, [RTM_time], [shMin], [shAmpl], [greal2000pi], 11624, 0
    fstp    dword[gharmY +sharm.freq2]
.exit:
DECLEND
;==============================================================================
SDECL _VPGM_sharm
;==============================================================================
    MPUSH   edi,ebp
    LCTX    ebp
    LARG    4, _pvert
    LVAR    vec4_size, rnormals
    LENTER
    
    mov     edi,dword[%$_pvert]
    fld     dword[RAS_main +raster.xtinfo +xtexinfo.uvMaxD2]
    fld     dword[edi +vertex.nx]
    fld     dword[edi +vertex.ny]
    fxch    st2
    fmul to st1
    fmul to st2
    fadd to st1
    faddp   st2
    fstp    dword[edi +vertex.u0]
    fstp    dword[edi +vertex.v0]

    lea     eax,[edi +vertex.nx]
    lea     edx,[%$rnormals]
    M33mulV3 edx, OBJ_tform +objtform.rm, eax
    fld     dword[RAS_main +raster.xtinfo +xtexinfo.uvMaxD2]
    fld     dword[%$rnormals +vec3.x]
    fld     dword[%$rnormals +vec3.y]
    fxch    st2
    fmul to st1
    fmul to st2
    fadd to st1
    faddp   st2
    fstp    dword[edi +vertex.u1]
    fstp    dword[edi +vertex.v1]
.exit
    LEXIT
    MPOP    edi,ebp
DECLEND
;==============================================================================
SDECL _renderHarm, 0
;==============================================================================
    RasSetTex   0, gtexWavy2
    RasSetTex   1, gtexRainbow2
    RasSetCulling CULLING_FRONT
    RasSetFpgm _FPGM_T0T1bi_Z
    RasSetVpgm _VPGM_T0T1

    CCALL   _getTimeMat,RTmatrix,97279,89741,[beatTimer +timer.sec]

    V3setNull RTmatrix +matrix.t
    ObjSetMat RTmatrix
    ObjSetScale harmonicScale
    ObjSetVpgm _VPGM_sharm
    ObjSetFlags 0, 0, OBJF_NORM
    CCALL   _SH_render3D, gharmX, gharmY, 48
.exit:
DECLEND
;==============================================================================
SDECL _setBeamCam, 0
;==============================================================================
    LCTX    esp
    LVAR    4, result

    CCALL   _getTimeMat,RTmatrix,79893,87420,[beatTimer +timer.sec]
    CCALL   _FN_sin, [RTM_time], [beamCamMinRad], [beamCamAmpl], [greal2000pi], 8000, [gZero]
    fchs
    fstp    dword[%$result]
    CCALL   _setMovingCam, [%$result]
.exit:
DECLEND
;==============================================================================
SDECL _renderGrid, 0
;==============================================================================
    MPUSH   ebp
    LCTX    ebp
    LARG    4, _pos, _ax, _ay, _az, _color
    LVAR    beam_size, mybeam
    LVAR    4, damp
    LENTER

    RasSetFpgm _FPGM_RGBxT0add_Z    
    M33fromEuler RTmatrix, [%$_ax], [%$_ay], [%$_az]
    mov     edx,dword[%$_pos]
    V3eq    RTmatrix +matrix.t, edx

    rgbaUnpack %$mybeam +beam.color, [%$_color]
    mov     eax,dword[beamdiam]
    mov     dword[%$mybeam +beam.diam],eax
    mov     eax,dword[beamlen]
    mov     dword[%$mybeam +beam.len],eax
    mov     dword[%$mybeam +beam.tex],gtexFlare1d
    mov     dword[%$mybeam +beam.flags],BEAMF_OFFSET
    lea     eax,[%$mybeam]
    CCALL   _BEAM_renderGrid, eax, RTmatrix, [gridStride], 19
.exit:
    LEXIT
    MPOP    ebp
DECLEND
;==============================================================================
SDECL _renderTrail, 0
;==============================================================================
    MPUSH   esi,edi,ebp
    LCTX    ebp
    LARG    4, _flags
    LVAR    4, xa, ya, min, seed, count
    LENTER
    
    mov     dword[%$seed],3895
    mov     esi,dword[gTrail]
    mov     edi,beamsTrailDat
    mov     dword[%$count],MAX_TRAILS
.iterTrail:
    IsSysFlagSet(SYSFLAG_UPDATE)
    jz      .endAddTrail
    test    byte[%$_flags],TRAILF_ADD
    jz      .endAddTrail

    lea     eax,[%$seed]
    RandF   eax
    fldpi
    fadd    st0
    fmulp   st1
    fstp    dword[%$min]
    CCALL   _FN_sin, [RTM_time], [%$min], REAL_PI, [greal2000pi], [edi +0], [gZero]
    fstp    dword[%$xa]
    CCALL   _FN_sin, [RTM_time], [%$min], REAL_PI, [greal2000pi], [edi +4], [gZero]
    fstp    dword[%$ya]
    M33fromEuler RTmatrix,[%$xa],[%$ya],[gZero]
    
    fld     dword[RTmatrix +matrix.u +vec3.z]
    fmul    dword[edi +16]
    fld     dword[RTmatrix +matrix.v +vec3.z]
    fmul    dword[edi +16]
    fld     dword[RTmatrix +matrix.n +vec3.z]
    fmul    dword[edi +16]
    fxch    st2
    fstp    dword[RTmatrix +matrix.t +vec3.x]
    fstp    dword[RTmatrix +matrix.t +vec3.y]
    fstp    dword[RTmatrix +matrix.t +vec3.z]

    CCALL   _TRAIL_add, esi, RTmatrix +matrix.t, REAL_1
.endAddTrail:
    
    test    byte[%$_flags],TRAILF_RENDER
    jz      .endRenderTrail
    xor     eax,eax
    mov     dword[esi +trail.angle],eax
    CCALL   _TRAIL_render, esi
    mov     dword[esi +trail.angle],REAL_PID2
    CCALL   _TRAIL_render, esi
.endRenderTrail:
    test    byte[%$_flags],TRAILF_UPDATE
    jz      .endUpdTrail
    CCALL   _TRAIL_update, esi, [RTM_dt]
.endUpdTrail:

;next
    add     esi,trail_size
    add     edi,20
    dec     dword[%$count]
    jnz     .iterTrail

.exit:
    LEXIT
    MPOP    esi,edi,ebp
DECLEND
;==============================================================================
SDECL _renderBeams, 0
;==============================================================================
    MPUSH   ebp
    LCTX    ebp
    LVAR    4, glareint, readyFlag, ampl, flag
    LENTER
;update
    TexClear    myscene +scene.fb
    CCALL   _setBeamCam
    CCALL   _renderTrail, TRAILF_ADD
    xor     eax,eax
    mov     dword[%$flag],eax
    
    mov     dword[%$ampl],1600
    fild    dword[%$ampl]
    fstp    dword[%$ampl]
    CCALL   _FN_sin, [RTM_time], 0, [%$ampl], [greal2000pi], 7000, 1
    fchs
    fist    dword[%$glareint]
    fstp    dword[%$readyFlag]
    test    dword[%$readyFlag],REAL_SIGNMASK
    jnz     .endRadial
    cmp     dword[%$glareint],255
    jl      .endClipInt
    mov     dword[%$glareint],255
.endClipInt:

    RasSetFpgm _FPGM_RGBxT0add
    CCALL   _renderTrail, TRAILF_RENDER
    
    CCALL   _TEX32_downsample, hdrscene +scene.fb, myscene +scene.fb
    mov     eax,dword[hdrscene +scene.fb +tex.w]
    mov     edx,dword[hdrscene +scene.fb +tex.h]
    shr     eax,1
    shr     edx,1
    CCALL   _TEX32_glare, hdrscene +scene.fb, eax,edx, 236, 18, 60, [%$glareint]
    TexClear    myscene +scene.fb
    mov     dword[%$flag],1
.endRadial:    

    TexClear    myscene +scene.zb
    CCALL   _renderHarm
    RasSetFpgm _FPGM_RGBxT0add_Z
    CCALL   _renderTrail, TRAILF_RENDER | TRAILF_UPDATE

    CCALL   _renderGrid, gpos1, [gZero],[gZero],[gZero], PACKB2DW(0,230,128,128)
    CCALL   _renderGrid, gpos2, [gZero], REAL_PID2, [gZero], PACKB2DW(0,128,128,230)
    CCALL   _renderGrid, gpos3, [gZero],[gZero],[gZero], PACKB2DW(0,128,230,128)
    CCALL   _renderGrid, gpos4, [gZero], REAL_PID2, [gZero], PACKB2DW(0,230,200,128)

    xor     eax,eax
    or      eax,dword[%$flag]
    jz      .exit
    CCALL   _TEX32_upsample, myscene +scene.fb, hdrscene +scene.fb
;    TexBlit myscene +scene.fb, hdrscene +scene.fb
    
.exit:
    LEXIT
    MPOP    ebp
DECLEND
;==============================================================================
