varying vec3 position;
varying vec3 normal;

uniform vec3 Feye;

void main()
{
	vec3 diffuse = vec3(0.8, 0.0, 0.0);
	vec3 specular = vec3(1.0, 1.0, 1.0);
	vec3 ambient = vec3(0.0, 0.0, 0.0);
	float shininess = 100.0;
	
	vec3 toEye = normalize(Feye - position);
	vec3 toLight = normalize(gl_LightSource[0].position.xyz - position);
	vec3 color = dot(toLight, normal) * diffuse + 
		pow(dot(normalize(toEye+toLight), normal), shininess) * specular + 
		ambient;
		
	toEye = normalize(Feye - position);
	toLight = normalize(gl_LightSource[1].position.xyz - position);
	color = dot(toLight, normal) * diffuse + 
		pow(dot(normalize(toEye+toLight), normal), shininess) * specular + 
		ambient;
		
	gl_FragColor = vec4(color, 1.0);
}