float4x4	matProj;				//macierz projekcji
float4x4	matWorld;				//macierz swiata
float4x4	matWorldIT;				//macierz swiata odwrotna transponowana
float3		fvSpecularPosition;	
float4		fvSpecularColor;		//kolor swiatla
float4		fvDiffuseColor;			//kolor swiatla
float3		fvEyePosition;			//pozycja oka
float3		fvDiffusePosition;		//pozyca swiatla
float		fSpecularPower=64;		//sila swiatla

texture		m_texture0;
texture		m_texture1;
texture		m_texture2;
texture		m_RenderTexture;
texture		m_textureCube0;
texture		m_RenderTexture2;
texture		m_VolumeTexture;

sampler2D renderTex2=sampler_state
{
    Texture = <m_RenderTexture2>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
};

sampler2D renderTex=sampler_state
{
    Texture = <m_RenderTexture>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
};

sampler2D tex0=sampler_state
{
    Texture = <m_texture0>;
//    AddressU = Clamp;
//    AddressV = Clamp;
    AddressU = Wrap;
    AddressV = Wrap;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
};

sampler2D tex1=sampler_state
{
    Texture = <m_texture1>;

    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
};

sampler2D tex2=sampler_state
{
    Texture = <m_texture2>;

    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
};

sampler texVolume=sampler_state
{
    Texture = <m_VolumeTexture>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
};

sampler texCube=sampler_state
{
    Texture = <m_textureCube0>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
};

struct VS_INPUT 
{
	float4 Pos:			POSITION0;
	float3 Normal:		NORMAL0;
	float2 Tex:			TEXCOORD0;
	float4 Col:			COLOR0;
};

struct VS_OUTPUT 
{
	float4 Pos:				POSITION;
	float4 LightColor:		COLOR0;
	float2 Tex:				TEXCOORD0;//koordynaty textury
	float3 LightDirect:		TEXCOORD3;//pozycja swiatla
	float3 Normal:			TEXCOORD4;//normale
};

struct VS_INPUT_2
{
	float4 Position:		POSITION0;
	float4 Normal:			NORMAL0;
	float2 Texture0:		TEXCOORD0;
};
/////////////////////////////
struct VS_OUTPUT_2
{
	float4 Position:		POSITION0;
	float2 Texture0:		TEXCOORD0;
	float3 Normal:			TEXCOORD1;
	float3 ViewVector:		TEXCOORD2;
	float3 LightDir:		TEXCOORD3;
	float3 SpecularDir:		TEXCOORD4;
	float4 SpecularColor: 	COLOR0;
};
//////////////////////////////
struct VS_BUMP_INPUT 
{
   float4 Position : POSITION0;
   float2 Texcoord : TEXCOORD0;
   float3 Normal :   NORMAL0;
   float3 Binormal : BINORMAL0;
   float3 Tangent :  TANGENT0;
};

struct VS_BUMP_OUTPUT 
{
   float4 Position :        POSITION0;
   float2 Texcoord :        TEXCOORD0;
   float3 ViewDirection :   TEXCOORD3;
   float3 LightDirection:   TEXCOORD2;
//   float4 DofDepth: 		COLOR0;
};

struct VS_BUMP_DOF_OUTPUT 
{
   float4 Position :        POSITION0;
   float2 Texcoord :        TEXCOORD0;
   float3 ViewDirection :   TEXCOORD3;
   float3 LightDirection:   TEXCOORD2;
   float4 DofDepth: 		COLOR0;
};

struct PS_BUMP_INPUT 
{
   float2 Texcoord :        TEXCOORD0;
   float3 ViewDirection :   TEXCOORD3;
   float3 LightDirection:   TEXCOORD2;
   float4 DofDepth: 		COLOR0;
};

struct PS_INPUT
{
	float2 Texcoord :       TEXCOORD0;
	float3 Normal :			TEXCOORD1;
	float3 ViewVector:		TEXCOORD2;
	float3 LightDirection:  TEXCOORD3;
	float3 SpecularDir:		TEXCOORD4;
	float4 LightColor:		COLOR0;
   
};
//////////hdr-test

struct PS_INPUT_HDR
{
   float2 Texcoord :        TEXCOORD0;
   float3 Normal :          TEXCOORD6;
   float3 ViewVector:		TEXCOORD2;
   float3 LightDir:			TEXCOORD3;
   float3 SpecularDir:		TEXCOORD4;
   float3 CubeCoord:		TEXCOORD5;
   float4 SpecularColor: 	COLOR0;
   //float4 Fresnel:			COLOR1;
};

struct VS_OUTPUT_HDR
{
	float4 Position:		POSITION0;
	float2 Texture0:		TEXCOORD0;
	float3 Normal:			TEXCOORD6;
	float3 ViewVector:		TEXCOORD2;
	float3 LightDir:		TEXCOORD3;
	float3 SpecularDir:		TEXCOORD4;
	float3 CubeCoord:		TEXCOORD5;
	float4 SpecularColor: 	COLOR0;
	//float4 Fresnel:			COLOR1;
};
/*
float fFarClamp=1.0;
float fDFar=40+10;
float fDFocus=28+10;
float fDNear=10+10;
*/

float fFarClamp=1.0;
float fDFar=40+10;
float fDFocus=28+10;
float fDNear=10+10;

/* osa
float fFarClamp=1.0;
float fDFar=2;
float fDFocus=0.5;
float fDNear=0.4;

*/
/*ksywki
float fFarClamp=1.0;
float fDFar=20;
float fDFocus=15.0;
float fDNear=10;

*/
/*dof efekt1
float fFarClamp=1.0;
float fDFar=100;
float fDFocus=20.0;
float fDNear=15;
*/
float ComputeDepthBlur (float fDepth)
{
   float f;
   if (fDepth < fDFocus)
   {
      f =(fDepth - fDFocus)/(fDFocus - fDNear);
   }
   else
   {
      f = (fDepth - fDFocus)/(fDFar - fDFocus);
      f = clamp (f, 0, fFarClamp);
   }
   return f * 0.5f + 0.5f;
}

float fFresnelConst=0.03;

VS_OUTPUT_HDR hdrVS( VS_INPUT Input)
{
	VS_OUTPUT_HDR Out;
	float3 fvObjectPosition=mul(Input.Pos,matWorld);
	float3 LightDirection=normalize(fvDiffusePosition - fvObjectPosition);
	float3 normal;
	normal=mul(Input.Normal,matWorldIT);
	float3 eyeVector=normalize(fvObjectPosition);
	float3 reflection=reflect(-eyeVector,normalize(normal));
	float4 fvPosition=mul(Input.Pos,matProj);
	Out.Position=fvPosition;
	Out.Texture0=Input.Tex;
	Out.Normal=normalize(normal);
	Out.ViewVector=fvObjectPosition;
	Out.LightDir=normalize(LightDirection);
	Out.SpecularDir=normalize(fvSpecularPosition-fvObjectPosition);
	float depth=ComputeDepthBlur(fvPosition.z);
	Out.SpecularColor.rgb=fvSpecularColor.rgb;
	Out.SpecularColor.a=depth;//glebokosc dla dofa
	//Out.Fresnel.rgb=fvSpecularColor.rgb;
	//Out.Fresnel.w=clamp(fFresnelConst+(1-fFresnelConst)*(pow(1-(reflection),1)),0.0f,1.0f);
	Out.CubeCoord=reflection;
	return Out;
}

float fExposure=1;
float fReflect=0.05;//0.05;
float fCubePow=0.55;//0.55;

//efekt4 0.05,0.55
//efekt3 freflect 0.3 fpow=1;
//efekt2 freflect 0.6
/////////sparametryzowac cala metode
float4 hdrPS( PS_INPUT_HDR Input ) : COLOR0
{
	float3 normal=Input.Normal;//normalize(Input.Normal);//Input.Normal;//=normalize(Input.Normal);
	float  fNDotL;
	float3 fvReflection;
	fNDotL=dot(normal,Input.LightDir);
	if(fNDotL<0) fNDotL=0;
	if(fNDotL>1) fNDotL=1;
	float4 fvBaseColor=tex2D( tex0, Input.Texcoord );
	float4 cubeColor=texCUBE(texCube,Input.CubeCoord);
	float4 fvTotalDiffuse=fNDotL*fvBaseColor*fvDiffuseColor;
	cubeColor=pow(cubeColor,fCubePow);
	fvTotalDiffuse=lerp(fvTotalDiffuse,cubeColor,fReflect);
	//fvTotalDiffuse = lerp(fvTotalDiffuse,cubeColor, 1-Input.Fresnel.w);
	fvReflection=normalize(((2.0f*normal)*(fNDotL))-Input.SpecularDir);
	float  specular=pow(saturate(dot(fvReflection, Input.SpecularDir)),fSpecularPower);
	float4 specularLight=specular;
	float3 tmp=(fvTotalDiffuse+specularLight*fvSpecularColor)*fExposure;
	float4 ret;
	ret.rgb=tmp.rgb;
	ret.a=Input.SpecularColor.a;
	
	return ret;
}

//////////lighting
VS_OUTPUT_2 main( VS_INPUT Input)
{
	VS_OUTPUT_2 Out;
	float3 fvObjectPosition = mul(Input.Pos,matWorld);
	float3 LightDirection   = normalize(fvDiffusePosition - fvObjectPosition);
	float3 Nrml             = mul(Input.Normal,matWorld);
	float4 fvPosition		= mul(Input.Pos,matProj);
	Out.Position=fvPosition;
	Out.Texture0=Input.Tex;
	Out.Normal=Nrml;
	Out.ViewVector=mul(Input.Pos,matWorld);
	Out.LightDir=LightDirection;
	Out.SpecularDir=normalize(fvSpecularPosition - fvObjectPosition);;
	Out.SpecularColor.rgb=fvSpecularColor.rgb;
	float depth=ComputeDepthBlur(fvPosition.z);
	Out.SpecularColor.a=depth;
	return Out;
}

float4 ps_main( PS_INPUT Input ) : COLOR0
{
	float3 nrml=Input.Normal;
	float  fNDotL           = dot(Input.Normal,Input.LightDirection); 
	float4 fvBaseColor      = tex2D( tex0, Input.Texcoord );
	float4 fvTotalDiffuse   = fNDotL*fvDiffuseColor*fvBaseColor;
	float3 fvReflection=normalize(((2.0f*Input.Normal)*(fNDotL))-Input.SpecularDir);
	float  specular=pow(saturate(dot(fvReflection, Input.SpecularDir)),fSpecularPower);
	float4 specularLight=specular;
	float4 color;
	color=fvTotalDiffuse+specularLight*fvSpecularColor;//lerp(fvTotalDiffuse,specularLight*fvSpecularColor,0.1);+
	//dodac obsluge dofa
	color.a=1;
	//color.a=Input.LightColor.a; 
	return color;
}
////////////liscie

float4 psLeafPien( PS_INPUT Input ) : COLOR0
{
	float3 nrml=Input.Normal;
	float  fNDotL           = dot(Input.Normal,Input.LightDirection); 
	if(fNDotL<0.3) fNDotL=0.3;
	float4 fvBaseColor      = tex2D( tex0, Input.Texcoord );
	float4 fvTotalDiffuse   = fNDotL*fvDiffuseColor*fvBaseColor;
	float4 color;
	color=fvTotalDiffuse;
	
	float tmp=fvBaseColor.r+fvBaseColor.g+fvBaseColor.b;
	tmp/=3;
	if(tmp<0.1) color.a=0; 
	else 
	{
		color.a=Input.LightColor.a;
		if(color.a<0.2) color.a=0.2;
	}
		
	//if(fvBaseColor.r>0.3) color.a=0; else color.a=1;
	
	return color;
}

float4 psLeaf( PS_INPUT Input ) : COLOR0
{
	float3 nrml=Input.Normal;
	float  fNDotL           = dot(Input.Normal,Input.LightDirection); 
	if(fNDotL<0.3) fNDotL=0.3;
	float4 fvBaseColor      = tex2D( tex0, Input.Texcoord );
	float4 fvTotalDiffuse   = fNDotL*fvDiffuseColor*fvBaseColor;
	float4 color;
	color=fvTotalDiffuse;
	
	if(fvBaseColor.r>0.3) color.a=0; 
	else 
	{
		color.a=Input.LightColor.a;
		if(color.a<0.3) color.a=0.3;
	}
	
	return color;
}

float4 psFly( PS_INPUT Input ) : COLOR0
{
	//float3 nrml=Input.Normal;
	//float  fNDotL           = dot(Input.Normal,Input.LightDirection); 
	//if(fNDotL<0.3) fNDotL=0.3;
	float4 fvBaseColor      = tex2D( tex0, Input.Texcoord );
	//float4 fvTotalDiffuse   = fNDotL*fvDiffuseColor*fvBaseColor;
	float4 color;
	color=fvBaseColor;//fvTotalDiffuse;
	float tmp=(fvBaseColor.r+fvBaseColor.g+fvBaseColor.b)/3;
	if(tmp>=0.98) color.a=0; else color.a=0.25f;
	
	return color;
}

////////////bumpmapping
struct VS_MORPH_BUMP_INPUT 
{
   float4 Position : POSITION0;
   float2 Texcoord : TEXCOORD0;
   float3 Normal :   NORMAL0;
   float3 Binormal : BINORMAL0;
   float3 Tangent :  TANGENT0;
   
   float4 Position2 : POSITION1;
   float3 Normal2 :   NORMAL1;
   float3 Binormal2 : BINORMAL1;
   float3 Tangent2 :  TANGENT1;
};

float fMorphPhase=0.9;

VS_BUMP_OUTPUT vsMorphBump(VS_MORPH_BUMP_INPUT In)
{
   VS_BUMP_OUTPUT Out;
   float4 fv4Pos=lerp(In.Position,In.Position2,fMorphPhase);
   Out.Position=mul(fv4Pos,matProj);
   Out.Texcoord=In.Texcoord;
   float3 fvObjectPosition=mul(In.Position,matWorld);
   float3 fvViewDirection=fvEyePosition-fvObjectPosition;	//pozycja oka
   float3 fvLightDirection=fvDiffusePosition-fvObjectPosition;//pozycja switala
   float3 fv3Normal=lerp(In.Normal,In.Normal2,fMorphPhase);
   float3 fv3Binormal=lerp(In.Binormal,In.Binormal2,fMorphPhase);
   float3 fv3Tangent=lerp(In.Tangent,In.Tangent2,fMorphPhase);
   
   float3 fvNormal=mul(fv3Normal,matWorld);//normalna
   float3 fvBinormal=mul(fv3Binormal,matWorld);//binormalna
   float3 fvTangent=mul(fv3Tangent,matWorld);//styczna

   Out.ViewDirection.x=dot(fvTangent,fvViewDirection);
   Out.ViewDirection.y=dot(fvBinormal,fvViewDirection);
   Out.ViewDirection.z=dot(fvNormal,fvViewDirection);
   
   Out.LightDirection.x=dot(fvTangent,fvLightDirection);//x
   Out.LightDirection.y=dot(fvBinormal,fvLightDirection);//y
   Out.LightDirection.z=dot(fvNormal,fvLightDirection);//z
   
   return(Out);
   
}

VS_BUMP_DOF_OUTPUT vsBump(VS_BUMP_INPUT In)
{
   VS_BUMP_DOF_OUTPUT Out;

   float4 fvPosition=mul(In.Position,matProj);
   Out.Position=fvPosition;
   Out.Texcoord=In.Texcoord;
   
   float4 DofDepth;
   float fDepth=ComputeDepthBlur(fvPosition.z);
   float3 fvObjectPosition = mul(In.Position,matWorld);
   
   float3 fvViewDirection  = fvEyePosition-fvObjectPosition;	//pozycja oka
   float3 fvLightDirection = fvDiffusePosition-fvObjectPosition;//pozycja switala
   float3 fvNormal         = mul(In.Normal,matWorld);//normalna
   float3 fvBinormal       = mul(In.Binormal,matWorld);//binormalna
   float3 fvTangent        = mul(In.Tangent,matWorld);//styczna

   Out.ViewDirection.x  = dot(fvTangent,fvViewDirection);
   Out.ViewDirection.y  = dot(fvBinormal,fvViewDirection);
   Out.ViewDirection.z  = dot(fvNormal,fvViewDirection);
   
   Out.LightDirection.x  = dot(fvTangent,fvLightDirection);//x
   Out.LightDirection.y  = dot(fvBinormal,fvLightDirection);//y
   Out.LightDirection.z  = dot(fvNormal,fvLightDirection);//z
   Out.DofDepth=0;//DofDepth;
   Out.DofDepth.a=fDepth;
   return(Out);
}

float4 psBump(PS_BUMP_INPUT Input) : COLOR0
{
   float3 fvLightDirection = normalize(Input.LightDirection);
   float3 fvNormal         = normalize((tex2D(tex1,Input.Texcoord).xyz*2.0f)-1.0f);
   float  fNDotL           = dot(fvNormal,fvLightDirection); 
   float3 fvReflection     = normalize(((2.0f*fvNormal)*(fNDotL))-fvLightDirection); 
   float3 fvViewDirection  = normalize(Input.ViewDirection);
   float  fRDotV           = max(0.0f,dot(fvReflection,fvViewDirection));
   float4 fvBaseColor      = tex2D(tex0,Input.Texcoord);
   float4 fvTotalDiffuse   = fvDiffuseColor*fNDotL*fvBaseColor; 
   float4 fvTotalSpecular  = fvSpecularColor*pow(fRDotV,fSpecularPower);
   float4 fvReturn;
   float4 fvTmp=saturate(fvTotalDiffuse+fvTotalSpecular);//fvTotalDiffuse;//(saturate(fvTotalDiffuse+fvTotalSpecular));;//fvTotalDiffuse;//+fvTotalSpecular;//(saturate(fvTotalDiffuse+fvTotalSpecular));
   float4 DofDepth=Input.DofDepth;
   float4 fColor2=tex2D(tex2,Input.Texcoord*2);//pobieram caustyke
   fvTmp=lerp(fvTmp,fColor2,0.15f);
   fvReturn.rgb=fvTmp.rgb;
   //fvReturn.rgb=fColor2;
   fvReturn.a=DofDepth.a;
   return fvReturn;
}
/////////blur
struct VS_OUTPUT_BLUR 
{
   float4 Position:		POSITION;
   float2 TexCoord:		TEXCOORD0;
};

struct VS_INPUT_BLUR 
{
   float4 Position:		POSITION;
   float2 TexCoord:		TEXCOORD0;
};

VS_OUTPUT_BLUR vsBlur(VS_INPUT_BLUR In)
{
	VS_OUTPUT_BLUR Out;
	Out.Position=mul(In.Position,matProj);
	Out.TexCoord=In.TexCoord;
	return Out;
}

float2 fv2BlurOffsets[12] = 
{
   -0.326212, -0.405805,
   -0.840144, -0.073580,
   -0.695914,  0.457137,
   -0.203345,  0.620716,
    0.962340, -0.194983,
    0.473434, -0.480026,
    0.519456,  0.767022,
    0.185461, -0.893124,
    0.507431,  0.064425,
    0.896420,  0.412458,
   -0.321940, -0.932615,
   -0.791559, -0.597705,
};

float fBlurScale;

float4 psBlur(float2 TexCoord: TEXCOORD0) : COLOR 
{
   float4 f4BlurColor = tex2D(tex0,TexCoord);

   for (int i = 0; i < 12; i++)
   {
      f4BlurColor += tex2D(tex0, TexCoord+ fBlurScale * fv2BlurOffsets[i]);
   }

   
   f4BlurColor/=13;
   return f4BlurColor;
}
//////////dof
struct VS_DOF_INPUT 
{
	float4 Pos:			POSITION;
	float2 Texcoord:	TEXCOORD0;
	float4 Col:			COLOR0;
};

struct VS_DOF_OUTPUT 
{
	float4 Pos:			POSITION;
	float2 Texcoord:	TEXCOORD0;
};

struct PS_DOF_INPUT 
{
	float2 Texcoord:	TEXCOORD0;
};

VS_DOF_OUTPUT vsDOF(VS_DOF_INPUT Input)
{
	VS_DOF_OUTPUT Out;
	Out.Pos=mul(Input.Pos,matProj);
	Out.Texcoord=Input.Texcoord;
	return Out;
}

float4 psDOF(PS_DOF_INPUT Input ) : COLOR0
{
	float4 color= tex2D(tex0,Input.Texcoord);
	float depth=color.a;
	
	if(depth!=0)
	{
		float4 f4BlurColor = tex2D(tex0,Input.Texcoord);
		//for (int i = 0; i < 12; i++)
		{
		//	f4BlurColor += tex2D(tex0, Input.Texcoord+ 0.006* fv2BlurOffsets[i]);//bylo 0.003
		}
		//f4BlurColor/=13;
		color  =lerp(color,f4BlurColor,depth);
	}
	//else
	{
	/*
		color.r=depth;
		color.g=depth;
		color.b=depth;
		*/
	}
	
	return color;
}

float4 psDOFBW(PS_DOF_INPUT Input ) : COLOR0
{
	float4 color= tex2D(tex0,Input.Texcoord);
	float depth=color.a;
	
	if(depth!=0)
	{
		float4 f4BlurColor = tex2D(tex0,Input.Texcoord);
		for (int i = 0; i < 12; i++)
		{
			f4BlurColor += tex2D(tex0, Input.Texcoord+ 0.003* fv2BlurOffsets[i]);//bylo 0.003
		}
		f4BlurColor/=13;
		color  =lerp(color,f4BlurColor,depth);
	}
	depth=(color.r+color.g+color.b)/3;
	
	color.r=depth;
	color.g=depth;
	color.b=depth;
	return color;
}

/////////////////////
struct VS_OUTPUT_DEFAULT
{
   float4 Position:		POSITION;
   float2 TexCoord:		TEXCOORD0;
   
};

struct VS_INPUT_DEFAULT 
{
   float4 Position:		POSITION;
   float2 TexCoord:		TEXCOORD0;
};


VS_OUTPUT_DEFAULT vsDefault(VS_INPUT_DEFAULT In)
{
	VS_OUTPUT_DEFAULT Out;
	Out.Position=mul(In.Position,matProj);
	Out.TexCoord=In.TexCoord;
	return Out;
}

float4 psMask(float3 TexCoord: TEXCOORD0) : COLOR 
{

   float4 fColor=1;
   return fColor;
}
///////////////////////
struct VS_OUTPUT_CAUST
{
	float4 Position:		POSITION0;
	float2 Texture0:		TEXCOORD0;
	float3 Normal:			TEXCOORD6;
	float3 ViewVector:		TEXCOORD2;
	float3 LightDir:		TEXCOORD3;
	float4 SpecularColor: 	COLOR0;
};

struct PS_INPUT_CAUST
{
   float2 Texcoord :        TEXCOORD0;
   float3 Normal :          TEXCOORD6;
   float3 ViewVector:		TEXCOORD2;
   float3 LightDir:			TEXCOORD3;
   float4 SpecularColor: 	COLOR0;
};

VS_OUTPUT_CAUST vsCaustick(VS_INPUT Input)
{
	VS_OUTPUT_CAUST Out;
	float3 fvObjectPosition=mul(Input.Pos,matWorld);
	float3 LightDirection=normalize(fvDiffusePosition - fvObjectPosition);
	float3 normal=mul(Input.Normal,matWorldIT);
	float4 fvPosition=mul(Input.Pos,matProj);
	Out.Position=fvPosition;
	Out.Texture0=Input.Tex;
	Out.Normal=normalize(normal);
	Out.ViewVector=fvObjectPosition;
	Out.LightDir=normalize(LightDirection);
	float depth=ComputeDepthBlur(fvPosition.z);
	Out.SpecularColor.rgb=fvSpecularColor.rgb;
	Out.SpecularColor.a=depth;//glebokosc dla dofa
	return Out;
}

float4 psCaustick(PS_INPUT_CAUST Input) : COLOR
{
	float3 normal=Input.Normal;
	float  fNDotL=dot(normal,Input.LightDir);
	float4 fvBaseColor=tex2D(tex0,Input.Texcoord);
	float4 fvCaustColor=tex2D(tex2,Input.Texcoord*8);
	float4 fvTotalDiffuse=fNDotL*fvBaseColor;//*fvDiffuseColor;
	float3 tmp=fvTotalDiffuse;//*fExposure;
	float4 ret=0;
	ret.rgb=lerp(tmp.rgb,fvCaustColor.rgb,0.2);
	//ret.rgb+=fvCaustColor.rgb;
	ret.a=Input.SpecularColor.a;
	return ret;
}
///////////////////////
float fFader=0;
float4 psFader(float3 TexCoord: TEXCOORD0) : COLOR 
{
   float4 fColor = tex2D(tex0,TexCoord);
   return fColor*fFader;
}
///////////////////////
float4 psDefault(float3 TexCoord: TEXCOORD0) : COLOR 
{
/*
   float4 fColor = tex2D(tex0,TexCoord);
   if(fColor.r>0.3) fColor.a=0;
   fColor.a=1;
   */
   
   float4 fColor = tex2D(tex0,TexCoord);
   return fColor;
}
/////////////////////
struct VS_OUTPUT_SPRITE
{
   float4 Position:		POSITION;
   float4 Color:		COLOR0;   
};

struct VS_INPUT_SPRITE 
{
   float4 Position:		POSITION;
   float4 Color:		COLOR0;
};


VS_OUTPUT_SPRITE vsSprite(VS_INPUT_SPRITE In)
{
	VS_OUTPUT_SPRITE Out;
	float4 fvPosition=mul(In.Position,matProj);
	Out.Position=fvPosition;
	float depth=ComputeDepthBlur(fvPosition.z);
	float4 fvColor=In.Color;
	fvColor.a=depth;
	Out.Color=fvColor;
	return Out;
}


float4 psSprite(float3 TexCoord: TEXCOORD0) : COLOR 
{
   float4 fColor = tex2D(tex0,TexCoord);
   fColor.a=0;
   return fColor;
}
///////////////skybox
float4x4 matInvProj;

struct SkyboxVS_Input
{
    float4 Pos : POSITION;
};

struct SkyboxVS_Output
{
    float4 Pos : POSITION;
    float3 Tex : TEXCOORD0;
};

SkyboxVS_Output SkyboxVS( SkyboxVS_Input Input )
{
    SkyboxVS_Output Output;
    Output.Pos = Input.Pos;
    Output.Tex = normalize( mul(Input.Pos,matInvProj));
    return Output;
}

float fSkyBoxScale=0;

float4 SkyboxPS( SkyboxVS_Output Input ) : COLOR
{
    float4 color = texCUBE(texCube,Input.Tex);
    float4 ret=color*fSkyBoxScale*fExposure;
    ret.a=1;
    return ret;
}
////////////renderbuffer

float4 RenderBufferPS(float2 TexCoord: TEXCOORD0) : COLOR
{
    float4 color = tex2D(renderTex,TexCoord);
    return color;
}


float4 RenderBufferPS2(float2 TexCoord: TEXCOORD0) : COLOR
{
    float4 color = tex2D(renderTex2,TexCoord);
    return color;
}

static const int fBlurSize = 13;

float2 fv2OffsetH[fBlurSize] =
{
    { -6.f/640.f, 0 },
    { -5.f/640.f, 0 },
    { -4.f/640.f, 0 },
    { -3.f/640.f, 0 },
    { -2.f/640.f, 0 },
    { -1.f/640.f, 0 },
    {  0.f/640.f, 0 },
    {  1.f/640.f, 0 },
    {  2.f/640.f, 0 },
    {  3.f/640.f, 0 },
    {  4.f/640.f, 0 },
    {  5.f/640.f, 0 },
    {  6.f/640.f, 0 },
};

static const float BlurWeights[fBlurSize] = 
{
    0.002216,
    0.008764,
    0.026995,
    0.064759,
    0.120985,
    0.176033,
    0.199471,
    0.176033,
    0.120985,
    0.064759,
    0.026995,
    0.008764,
    0.002216,
};

float2 fv2OffsetV[fBlurSize] =
{
    { 0, -6.f/480.f },
    { 0, -5.f/480.f },
    { 0, -4.f/480.f },
    { 0, -3.f/480.f },
    { 0, -2.f/480.f },
    { 0, -1.f/480.f },
    { 0,  0.f/480.f },
    { 0,  1.f/480.f },
    { 0,  2.f/480.f },
    { 0,  3.f/480.f },
    { 0,  4.f/480.f },
    { 0,  5.f/480.f },
    { 0,  6.f/480.f },
};

float fBloomScale=1.0f;

float4 GBlurHPS( float2 Tex : TEXCOORD0 ) : COLOR0
{
    float4 Color = 0;
    
    for (int i = 0; i < fBlurSize; i++)
    {   
		Color+=tex2D( renderTex, Tex+ fv2OffsetH[i].xy ) * BlurWeights[i];        
    }
	//Color=tex2D( renderTex, Tex);        
    return Color*fBloomScale;
}

float4 GBlurVPS( float2 Tex : TEXCOORD0 ) : COLOR0
{
    float4 Color = 0;
    for (int i = 0; i < fBlurSize; i++)
    {    
	    Color+=tex2D( renderTex, Tex+ fv2OffsetV[i].xy ) * BlurWeights[i];        
    }
    //Color=tex2D( renderTex, Tex);        
    return Color*fBloomScale;
}

float4 CopyRTPS( float2 Tex : TEXCOORD0 ) : COLOR0
{
    return tex2D( renderTex, Tex );
}

float fDiv=4;

VS_OUTPUT_DEFAULT vsPost(VS_INPUT_DEFAULT In)
{
	VS_OUTPUT_DEFAULT Out;
	float4 vPos=In.Position;
	//////dodac 1/8 ekranu
	vPos.xy = sign(vPos.xy)*1/fDiv;
	vPos.y*=-1;
	if(vPos.x<0) vPos.x=-1.f;
	else vPos.x=-1.f+2.f/fDiv;
	if(vPos.y>0) vPos.y=1.f;
	else vPos.y=1.f-2.f/fDiv;

/*	
	vPos.xy = sign(vPos.xy)*0.25;
	vPos.y*=-1;
	if(vPos.x<0) vPos.x=-1.f;
	else vPos.x=-.5f;
	if(vPos.y>0) vPos.y=1.f;
	else vPos.y=.5f;
*/	
	vPos.z=0;
	vPos.w=1;
	Out.Position=vPos;
	Out.TexCoord=In.TexCoord;
	return Out;
}

VS_OUTPUT_DEFAULT vsBuff(VS_INPUT_DEFAULT In)
{
	VS_OUTPUT_DEFAULT Out;
	float4 vPos=In.Position;
	vPos.xy = sign(vPos.xy);
	vPos.y*=-1;
	if(vPos.x<0) vPos.x-=1/640.f;
	if(vPos.y>0) vPos.y+=1/480.f;
	vPos.z=0;
	vPos.w=1;
	Out.Position=vPos;
	Out.TexCoord=In.TexCoord;
	return Out;
}
////////////

float fToneMappingGray=0.18f;
float fToneMappingLuminace=0.18f;
float fToneMappingWhiteCutoff=0.8f;
bool isToneMapping=true;

float4 DofPS( float2 Texcoord : TEXCOORD0 ) : COLOR0
{
	float4 color= tex2D(tex0,Texcoord);
	float4 color2= tex2D(renderTex,Texcoord);
	float depth=color.a;
	if(depth>0.8f) depth=0.8f;
	color=lerp(color,color2,depth);
    
	if(isToneMapping)
	{
		color*=(fToneMappingGray / ( fToneMappingLuminace + 0.001f ));
		color*=(1.f+(color/(fToneMappingWhiteCutoff*fToneMappingWhiteCutoff)));
		color/=(1.f+color);
    }
	/*
    color.r=depth;
	color.g=depth;
	color.b=depth;
	*/
	return color;
}
///////////
float fLuminance = 0.08f;
static const float fMiddleGray = 0.18f;
static const float fWhiteCutoff = 0.8f;

float4 BrightPassFilter(float2 Texcoord:TEXCOORD0):COLOR0
{
	float3 color2= tex2D(renderTex,Texcoord);
		color2*=fMiddleGray/(fLuminance+0.001f);
		color2*=(1.0f+(color2/(fWhiteCutoff*fWhiteCutoff)));
		color2-=5.0f;
		color2=max(color2,0.0f);
		color2/=(10.0f+color2);
	return float4(color2,1.0f);
}

bool isBloomMirror=false;
float fScreenWidth=640.f;
float fScreenHeight=480.f;
float fScrollY=480;
////////////////////////////////
float4 psBackground(float2 Texcoord:TEXCOORD0):COLOR0
{
	float4 color=tex2D(tex0,Texcoord);
	float2 fCoord=Texcoord;
	fCoord.x-=(fScreenWidth-256.f)/fScreenWidth*0.5f;
	fCoord.x*=fScreenWidth/256.f;
	fCoord.y-=fScrollY/fScreenHeight;
	fCoord.y*=fScreenHeight/1024.f;
	if(fCoord.y<0) fCoord.y=0;
	if(fCoord.y>1) fCoord.y=1;
	if(fCoord.x<0) fCoord.x=0;
	if(fCoord.x>=1) fCoord.x=1;
	float4 scroll=tex2D(tex1,fCoord);

	if(fCoord.y<0) scroll=0;
	if(fCoord.y>1) scroll=0;
	if(fCoord.x<=0) scroll=0;
	if(fCoord.x>=1) scroll=0;
	
	float4 ret=lerp(color,scroll,scroll.a);
	if(scroll.a==0) ret=color;
	return ret*fExposure;
}

float fCrossFade=0;

float4 psCrossFade(float2 Texcoord:TEXCOORD0):COLOR0
{
	float4 color=tex2D(tex0,Texcoord);//zrodlo 1
	float4 color2=tex2D(tex1,Texcoord);//zrodlo 2
	float4 ret=lerp(color,color2,fCrossFade);
	return ret;
}

////////////////////////////////
//AlphaTransPS
float fAlphaTest=0;
bool isFix=true;

float4 Alpha2TransPS(float2 Texcoord:TEXCOORD0):COLOR0
{
	float2 fCoord=Texcoord;
	float4 color=tex2D(tex0,fCoord);//zrodlo 1
	float4 color2=tex2D(tex1,fCoord);//zrodlo 2
	float4 color3=tex2D(tex2,fCoord);//alfa
	float4 ret;
    float test=color3.r;
    if(test==0) color=color2;
///////////////////////
	ret=color;
	if(fCoord.x<(1.f/640.f) && isFix) ret=color2;
	return ret;
}

float4 AlphaTransPS(float2 Texcoord:TEXCOORD0):COLOR0
{
	float2 fCoord=Texcoord;
	float4 color=tex2D(tex0,fCoord);//zrodlo 1
	float4 color2=tex2D(tex1,fCoord);//zrodlo 2
	float4 ret;
    float3 pos=0;
    pos.xy=Texcoord;
    pos.z=0.5f;
	float4 fvNoise=tex3D(texVolume,pos);
    float test=fvNoise.r;
    if(test<=fAlphaTest) 
    {
		if(test<=fAlphaTest-0.05) color=color2;
		else color=lerp(color,color2,0.5);
    }//(color.r+color.g+color.b)/3;
    //if(test<=0.5f) color=0;
///////////////////////
	ret=color;//lerp(color,color2,1-test);
	return ret;
}
//////////////////////
struct VS_OUTPUT_REFRACTION
{
   float4 Position:		POSITION;
   float2 Texcoord:		TEXCOORD0;
   float3 Eye:			TEXCOORD1;
};

struct PS_INPUT_REFRACTION
{
   float3 Texcoord:		TEXCOORD0;
   float3 Eye:			TEXCOORD1;
};

VS_OUTPUT_REFRACTION refractionVS(VS_INPUT_DEFAULT In)
{
	VS_OUTPUT_REFRACTION Out;
	float4 vPos=In.Position;
	vPos.xy = sign(vPos.xy);
	vPos.y*=-1;
	if(vPos.x<0) vPos.x-=1/640.f;
	if(vPos.y>0) vPos.y+=1/480.f;
	vPos.z=0;
	vPos.w=1;
	Out.Position=vPos;
	Out.Texcoord=In.TexCoord;
	
	Out.Eye.x = 0.5 * (vPos.z + vPos.x);
	Out.Eye.y = 0.5 * (vPos.z - vPos.y);
	Out.Eye.z = vPos.z;
	return Out;
}
float3 fOffsetY = float3(0.31, 0.12, 0.52);
float3 fOffsetZ = float3(0.31, 0.5, 0.5);
float fRefTime=0;
float4 fWaterColor=float4(0.0,0.1,0.4,1);

float4 refractionPS(PS_INPUT_REFRACTION Input):COLOR0
{
	float2 fCoord=Input.Texcoord.xy;
	float3 fNoiseCoord=Input.Texcoord.xyz*0.3;
	fNoiseCoord.z=0.1*fRefTime;
	float4 fColor=tex2D(tex0,fCoord);
	float4 fColor2=tex2D(tex1,fCoord);
	float fNoisy=tex3D(texVolume,fNoiseCoord);//pobieram wielkosc x
	fNoiseCoord.x=0.1*fRefTime;
	fNoiseCoord.y=Input.Texcoord.y*2;
	fNoiseCoord.z=Input.Texcoord.z+0.2*fRefTime+fNoisy;    
	float3 fNormal;
    fNormal.x=tex3D(texVolume,fNoiseCoord).x;
    fNormal.y=tex3D(texVolume,fNoiseCoord+fOffsetY).x;
    fNormal.z=tex3D(texVolume,fNoiseCoord+fOffsetZ).x;
    fNormal=normalize(fNormal*2-1);
///////////////////
	float2 fCoord2=fCoord*0.98+0.02*fNormal.xy;
	if(fCoord2.x<(1.f/640.f)) fCoord2.x=(1.f/640.f); //else fCoord2.x=1;
	if(fCoord2.y<(1.f/480.f)) fCoord2.y=(1.f/480.f); //else fCoord2.y=1;
	
	float4 ret = tex2D(tex0, fCoord2);
	float tmp=0;
	float4 fColorBlur=0;
	if(fColor2.a!=0)
	{
		tmp=(fColor2.r+fColor2.g+fColor2.b)/3;
		fWaterColor=float4(
		14.f/255.f, 
		14.f/255.f, 
		10.f/255.f,
		1);
		ret=(fWaterColor)*(1-ret)+ret; 
		//else 
		{
		/*
			fCoord2=fCoord;
			
			fCoord2.x+=1.f/640.f;
			//fColorBlur=fColor2;
			fWaterColor=float4(0,0,0.3,1);
			fColorBlur=(fWaterColor)*(1-ret)+ret;
			//fColorBlur+=tex2D(tex0,fCoord2);
			fCoord2=fCoord;
			fCoord2.x-=1.f/640.f;
			//fColorBlur+=tex2D(tex0,fCoord2);
			
			fCoord2=fCoord;
			fCoord2.y-=1.f/480.f;
			//fColorBlur+=tex2D(tex0,fCoord2);
			
			fCoord2=fCoord;
			fCoord2.y+=1.f/480.f;
			//fColorBlur+=tex2D(tex0,fCoord2);
			
			ret=fColorBlur;///4;
			*/
		}
	} else ret=fColor;
	//ret=fColor2;
	return ret;
}

//////////////////////
float fTestX=0;
float fTestY[16]=
{
0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,
};

float4 LineTransPS(float2 Texcoord:TEXCOORD0):COLOR0
{
	float2 fCoord=Texcoord;
	float4 color=tex2D(tex0,fCoord);//zrodlo 1
	float4 color2=tex2D(tex1,fCoord);//zrodlo 2
	float4 ret=0;
	float testX=fCoord.x*640;
	float testY=fCoord.y*480;
	float t2=0;
	int t=testY;
	int t3=t/16;
	t=t-t3*16;
	if(t<=15)t2=fTestY[t];
	if(t2==0) 
	{
		if(testX>640-fTestX) ret=color2; else ret=color;
	}
	else 
	{
		if(testX<fTestX) ret=color2; else ret=color;
	}

	//ret=color2;
	return ret;
}
float4 Bloom2PS(float2 Texcoord:TEXCOORD0):COLOR0
{
	float2 fCoord=Texcoord;
	
	float4 color=tex2D(tex0,fCoord);
	float4 color2=tex2D(tex1,fCoord);
	float4 colorBloom=tex2D(renderTex,fCoord);
	float4 ret=0.5;
	float tmp;
	
	
	tmp=color.r+color.g+color.b;
		
	if(tmp==0) 
	{
		fCoord.x+=14.f/640.f;
		fCoord.y+=14.f/480.f;
		if(fCoord.x<1 && fCoord.y<1)
		{
			color=tex2D(tex0,fCoord);
			tmp=color.r+color.g+color.b;
		}
		else tmp=0;
		if(tmp!=0) ret=color2*0.5;
		else ret=color2;
	}
	else ret=color;
	ret+=colorBloom;
	
	return ret;

}

////////////////////////////////
float fBloomBlend=0.09f;

float4 BloomPS(float2 Texcoord:TEXCOORD0):COLOR0
{
	float2 fCoord=Texcoord;
	float4 color=tex2D(tex0,fCoord);
	
	color+=tex2D(renderTex,fCoord);
	if(isBloomMirror)
	{
		if(fBloomBlend==0.5f)
		{
			fCoord.y=1-fCoord.y;
		}

		fCoord.x=1-fCoord.x;
		float4 color2= tex2D(tex0,fCoord);
		color2+=tex2D(renderTex,fCoord);
		color=lerp(color,color2,fBloomBlend);
	}
	
	if(isToneMapping)
	{
		color*=(fToneMappingGray / ( fToneMappingLuminace + 0.001f ));
		color*=(1.f+(color/(fToneMappingWhiteCutoff*fToneMappingWhiteCutoff)));
		color/=(1.f+color);
    }
	
	
	return color;
}
///////////
struct PS_INPUT_HDR2
{
	float3 ReflectPos:		TEXCOORD3;
	float3 Normal:			TEXCOORD6;
	float3 ViewVector:		TEXCOORD2;
    float4 Depth:			COLOR0;
};

struct VS_OUTPUT_HDR2
{
	float4 Position:		POSITION0;
	float3 ReflectPos:		TEXCOORD3;
	float3 Normal:			TEXCOORD6;
	float3 ViewVector:		TEXCOORD2;
	float4 Depth:			COLOR0;
};

float4 refScale=(0.1f,0.01f,0.01f,0.0f);
float fTime=0;

VS_OUTPUT_HDR2 hdr2VS( VS_INPUT Input)
{
	VS_OUTPUT_HDR2 Out;
	float4 Pos=Input.Pos;
	Pos.xz*=800;
	Pos.y=-100;
	float3 fvObjectPosition=mul(Pos,matWorld);
	Pos.y=0;
	float4 fvPosition=mul(Pos,matProj);
	Out.Position=fvPosition;
	Pos.xz/=150;
	Pos.y=0;
	Out.ReflectPos=Pos;
	Out.Normal=Input.Normal;
	Out.ViewVector=fvObjectPosition;
	float depth=ComputeDepthBlur(fvPosition.z);
	float4 fvDepth=0;
	fvDepth.a=depth;
	Out.Depth=fvDepth;
	return Out;
}

float4 hdr2PS( PS_INPUT_HDR2 Input ) : COLOR0
{
	float3 pos=Input.ReflectPos;
	pos.x+=fTime*0.13f;
	pos.z+=fTime*0.02f;
	pos.y+=fTime*0.095f;
	float4 fvNoise=tex3D(texVolume,pos);
	float3 bump =2*fvNoise-1;
	bump.xz *= 0.15;
    bump.y = 0.8 * abs(bump.y) + 0.2;
    bump = normalize(Input.Normal + bump);
    float3 reflVec = reflect(Input.ViewVector, bump);
    float4 refl = texCUBE(texCube, reflVec);
    refl.a=Input.Depth.a;
	float4 ret=refl;
	return ret;
}
///////////
technique RenderHDR2
{
	pass P0
	{
		VertexShader = compile vs_2_0 hdr2VS();
	    PixelShader  = compile ps_2_0 hdr2PS();
	}
}
////////////////

technique DofProcess
{
    pass p0
    {
        //VertexShader = null;
		VertexShader = compile vs_2_0 vsBuff();
        PixelShader = compile ps_2_0 DofPS();
        ZEnable = false;
    }
}

technique BrightFilter
{
    pass p0
    {
        //VertexShader = null;
        VertexShader = compile vs_2_0 vsPost();
        PixelShader = compile ps_2_0 BrightPassFilter();
        ZEnable = false;
    }
}

technique RenderBloom2
{
    pass p0
    {
        VertexShader = compile vs_2_0 vsBuff();
        PixelShader = compile ps_2_0 Bloom2PS();
        ZEnable = false;	
    }
}

technique RenderLineTrans
{
    pass p0
    {
        VertexShader = compile vs_2_0 vsBuff();
        PixelShader = compile ps_2_0 LineTransPS();
        ZEnable = false;	
    }
}

technique RenderRefraction
{
    pass p0
    {
        VertexShader = compile vs_2_0 refractionVS();
        PixelShader = compile ps_2_0 refractionPS();
        ZEnable = false;	
    }
}

technique RenderAlphaTrans
{
    pass p0
    {
        VertexShader = compile vs_2_0 vsBuff();
        PixelShader = compile ps_2_0 AlphaTransPS();
        ZEnable = false;	
    }
}

technique RenderBackground
{
    pass p0
    {
        VertexShader = compile vs_2_0 vsBuff();
        PixelShader = compile ps_2_0 psBackground();
        ZEnable = false;	
    }
}

technique RenderAlpha2Trans
{
    pass p0
    {
        VertexShader = compile vs_2_0 vsBuff();
        PixelShader = compile ps_2_0 Alpha2TransPS();
        ZEnable = false;	
    }
}

technique RenderCrossFade
{
    pass p0
    {
        VertexShader = compile vs_2_0 vsBuff();
        PixelShader = compile ps_2_0 psCrossFade();
        ZEnable = false;	
    }
}

technique RenderBloom
{
    pass p0
    {
        VertexShader = compile vs_2_0 vsBuff();
        PixelShader = compile ps_2_0 BloomPS();
        ZEnable = false;
    }
}

technique DownFilter
{
    pass p0
    {
        VertexShader = null;
        //VertexShader = compile vs_2_0 vsPost();
        PixelShader = compile ps_2_0 CopyRTPS();
        ZEnable = false;
    }
}

technique UpFilter
{
    pass p0
    {
        VertexShader = null;
		//VertexShader = compile vs_2_0 vsPost();
        PixelShader = compile ps_2_0 CopyRTPS();
        ZEnable = false;
    }
}
//////////////////////
technique GBlurV
{
    pass p0
    {
        //VertexShader = null;
        VertexShader = compile vs_2_0 vsPost();
        PixelShader = compile ps_2_0  GBlurVPS();
        ZEnable = false;
    }
}

technique GBlurH
{
    pass p0
    {
        //VertexShader = null;
        VertexShader = compile vs_2_0 vsPost();
        PixelShader = compile ps_2_0  GBlurHPS();
        ZEnable = false;
    }
}

technique RenderBuffer
{
    pass p0
    {
        //VertexShader = null;
        VertexShader = compile vs_2_0 vsPost();
        PixelShader = compile ps_2_0  RenderBufferPS();
        ZEnable = false;
    }
}

technique RenderUpBuffer
{
    pass p0
    {
        //VertexShader = null;
        VertexShader = compile vs_2_0 vsBuff();
        PixelShader = compile ps_2_0  RenderBufferPS();
        ZEnable = false;
    }
}
//////////////////////
technique Skybox
{
    pass p0
    {
        VertexShader = compile vs_2_0 SkyboxVS();
        PixelShader = compile ps_2_0 SkyboxPS();
    }
}

////////////prt

#define NUM_CHANNELS	3
#define NUM_CLUSTERS	1
#define NUM_PRT_WEIGHT			24
float4 fv4PRTConst[NUM_CLUSTERS*(1+NUM_CHANNELS*(NUM_PRT_WEIGHT/4))];
float4 fv4DiffColor = { 1.0f, 1.0f, 1.0f, 1.0f };    
float fColorScaler=1.0f;

float4 GetPRTDiffuse( int iClusterOffset, float4 fv4PRTWeights[NUM_PRT_WEIGHT/4] )
{
    float4 vColorR = float4(0,0,0,0);
    float4 vColorG = float4(0,0,0,0);
    float4 vColorB = float4(0,0,0,0);
    
    for (int j=0; j < (NUM_PRT_WEIGHT/4); j++) 
    {
        vColorR += fv4PRTWeights[j] * fv4PRTConst[iClusterOffset+1+(NUM_PRT_WEIGHT/4)*0+j];
        vColorG += fv4PRTWeights[j] * fv4PRTConst[iClusterOffset+1+(NUM_PRT_WEIGHT/4)*1+j];
        vColorB += fv4PRTWeights[j] * fv4PRTConst[iClusterOffset+1+(NUM_PRT_WEIGHT/4)*2+j];
    }    

    float4 vDiffuse = fv4PRTConst[iClusterOffset];
    vDiffuse.r += dot(vColorR,1);
    vDiffuse.g += dot(vColorG,1);
    vDiffuse.b += dot(vColorB,1);
    
    return vDiffuse;
}

struct VS_OUTPUT_PRT
{
    float4 Position  :		POSITION;
    float4 Diffuse   :		TEXCOORD6;
    float2 TexCoord  :		TEXCOORD0;
    float3 Normal:			TEXCOORD7;
	float3 ViewVector:		TEXCOORD2;
	float3 LightDir:		TEXCOORD3;
	float3 SpecularDir:		TEXCOORD4;
	float3 CubeCoord:		TEXCOORD5;
	float4 SpecularColor: 	COLOR1;
};

struct VS_INPUT_PRT
{
    float4 Position:POSITION;
    float2 TexCoord:TEXCOORD0;
	float3 Normal:	NORMAL0;
    int    iClusterOffset:BLENDWEIGHT;
    float4 fv4PRTWeights[NUM_PRT_WEIGHT/4]:BLENDWEIGHT1;
};
/////////////
VS_OUTPUT_PRT PRTDiffuseVS(VS_INPUT_PRT Input)                        
{
    VS_OUTPUT_PRT Output;

	float3 fvObjectPosition=mul(Input.Position,matWorld);
	float3 LightDirection=normalize(fvDiffusePosition-fvObjectPosition);
	//float3 normal=normalize(mul(Input.Normal,matWorld));
	float3 normal=(mul(Input.Normal,matWorld));
	float3 eyeVector=normalize(fvObjectPosition);
	float3 reflection=reflect(-eyeVector,normalize(normal));
	float4 fvPosition=mul(Input.Position,matProj);

    Output.Position=fvPosition;
    Output.TexCoord=Input.TexCoord;
    Output.Normal=normal*1000;
	Output.ViewVector=fvObjectPosition;
	Output.LightDir=LightDirection;
	Output.SpecularDir=normalize(fvSpecularPosition-fvObjectPosition);
	float depth=ComputeDepthBlur(fvPosition.z);
	Output.SpecularColor.rgb=fvSpecularColor.rgb;
	Output.SpecularColor.a=depth;//glebokosc dla dofa
	Output.CubeCoord=normalize(reflection);
    Output.Diffuse=GetPRTDiffuse(Input.iClusterOffset,Input.fv4PRTWeights);
    Output.Diffuse*=fv4DiffColor;
    return Output;
}
struct PS_OUTPUT_PRT
{   
    float4 RGBColor : COLOR0;
};
/////////////////////////
bool isPRTTex=true;//czy textura jest dostepna przy prt
bool isPRTSpecular=true;//prt+specular
bool isPRTCube=true;//czy jest odbicie srodowiska


bool isMono=false;

PS_OUTPUT_PRT PrtPS( VS_OUTPUT_PRT Input) 
{ 
    PS_OUTPUT_PRT Output;
    
    float4 fvTotalDiffuse=Input.Diffuse;
    ///wywalic
    if(isMono)
    {
	    float tmp=0;
		tmp=(fvTotalDiffuse.r+fvTotalDiffuse.g+fvTotalDiffuse.b)/3;
		fvTotalDiffuse.r=tmp;
		fvTotalDiffuse.g=tmp;
		fvTotalDiffuse.b=tmp;
    }
    //fvTotalDiffuse*=1.3f;
    ///dotad

    if(isPRTTex) 
    {
		float4 fvBaseColor=tex2D(tex0,Input.TexCoord);
		fvTotalDiffuse*=fvBaseColor;
    }

    if(isPRTCube)
    {
	   	float4 cubeColor=texCUBE(texCube,Input.CubeCoord);
	    cubeColor=pow(cubeColor,fCubePow);
	    //fReflect=0.5;
	    fvTotalDiffuse=lerp(fvTotalDiffuse,cubeColor,fReflect);
	    //fvTotalDiffuse*=cubeColor;//lerp(fvTotalDiffuse,cubeColor,fReflect);
    }
    
    if(isPRTSpecular)
    {
		float  fNDotL=dot(normalize(Input.Normal),Input.LightDir);
		float3 fvReflection=normalize(((2.0f*normalize(Input.Normal))*(fNDotL))-Input.SpecularDir);
		float  specular=pow(saturate(dot(fvReflection, Input.SpecularDir)),fSpecularPower);
		float4 specularLight=specular;
		fvTotalDiffuse+=specularLight*fvSpecularColor;
    }
    
    fvTotalDiffuse.a=Input.SpecularColor.a;
    Output.RGBColor=fvTotalDiffuse;
    return Output;
}
////////prt+specular
PS_OUTPUT_PRT PrtTexPS( VS_OUTPUT_PRT Input) 
{ 
    PS_OUTPUT_PRT Output;
    
	float  fNDotL=dot(Input.Normal,Input.LightDir); //kat miedzy swiatlem a normalna
   	float4 cubeColor=texCUBE(texCube,Input.CubeCoord);
    float4 fvBaseColor=tex2D(tex0,Input.TexCoord);    
    float4 fvTotalDiffuse=Input.Diffuse*fvBaseColor;//*fColorScaler;
	float3 fvReflection=normalize(((2.0f*Input.Normal)*(fNDotL))-Input.SpecularDir);
	float  specular=pow(saturate(dot(fvReflection, Input.SpecularDir)),fSpecularPower);
	float4 specularLight=specular;
    cubeColor=pow(cubeColor,fCubePow);
    fvTotalDiffuse=lerp(fvTotalDiffuse,cubeColor,fReflect);
    float4 tmp=(fvTotalDiffuse+specularLight*fvSpecularColor);//*fExposure;
    tmp.a=Input.SpecularColor.a;
    Output.RGBColor=tmp;//fvTotalDiffuse;
    return Output;
}
///////////blobs
struct VS_INPUT_BLOBS
{
   float4 Position:		POSITION;
   float3 Normal:		NORMAL0;
};

struct VS_OUTPUT_BLOBS
{
   float4 Position:		POSITION;
   float3 Normal:		TEXCOORD0;
   float3 ViewVector:	TEXCOORD1;
   float3 LightDir:		TEXCOORD2;
   float3 SpecularDir:	TEXCOORD3;
};

VS_OUTPUT_BLOBS vsBlobs(VS_INPUT_BLOBS Input)
{
	VS_OUTPUT_BLOBS Out;
	//Out.Position=mul(In.Position,matProj);
	//float3 nrm=;
	//Out.Normal=nrm;
	//Out.Normal=normalize(mul(In.Normal,matWorld));//normalize(mul(In.Position,matWorld));;//normalize(mul(In.Normal,matWorld));

	float3 fvObjectPosition=mul(Input.Position,matWorld);
	float3 LightDirection=normalize(fvDiffusePosition - fvObjectPosition);
	float3 normal=normalize(mul(Input.Normal,matWorld));
	float3 eyeVector=normalize(fvObjectPosition);
	float3 reflection=reflect(-eyeVector,normal);
	float4 fvPosition=mul(Input.Position,matProj);
	Out.Position=fvPosition;
	Out.Normal=eyeVector;//normal;
	Out.ViewVector=fvObjectPosition;
	Out.LightDir=LightDirection;
	Out.SpecularDir=normalize(fvSpecularPosition-fvObjectPosition);
	float depth=ComputeDepthBlur(fvPosition.z);
	//Out.SpecularColor.rgb=fvSpecularColor.rgb;
	//Out.SpecularColor.a=depth;//glebokosc dla dofa
	//Out.Fresnel.rgb=fvSpecularColor.rgb;
	//Out.Fresnel.w=clamp(fFresnelConst+(1-fFresnelConst)*(pow(1-(reflection),1)),0.0f,1.0f);
	//Out.CubeCoord=reflection;

	return Out;
}

float4 psBlobs(VS_OUTPUT_BLOBS Input) : COLOR 
{
   float4 fColor=texCUBE(texCube,Input.Normal);
   //if(fColor.r>0.3) fColor.a=0;
//   fColor.xyz=Normal.xyz;
//   fColor.a=1;
    float  fNDotL           = dot(Input.Normal,Input.LightDir); //kat miedzy swiatlem a normalna
	float4 fvBaseColor      = float4(0.8,0.8,0.8,0);// tex2D( tex0, Input.Texcoord );
	float4 fvSpecularColor      = float4(0.5,0.4,0.1,0.1);
	float4 cubeColor		= texCUBE(texCube,Input.Normal);//texCUBE(texCube,Input.CubeCoord);
	//if(fNDotL<0) fNDotL*=-1;
	if(fNDotL>1) fNDotL=0;
	
	float4 fvTotalDiffuse   = fNDotL*fvBaseColor;//*fvDiffuseColor*fvBaseColor;
	cubeColor=pow(cubeColor,fCubePow);
	
	fvTotalDiffuse=lerp(fvTotalDiffuse,cubeColor,0.6);
	//fvTotalDiffuse=lerp(fvTotalDiffuse,cubeColor,1-Input.Fresnel.w);//tlumienie
	//fvTotalDiffuse.x=Input.Fresnel.w;
	///fvTotalDiffuse.y=Input.Fresnel.w;
	//fvTotalDiffuse.z=Input.Fresnel.w;
	float3 fvReflection=normalize(((2.0f*Input.Normal)*(fNDotL))-Input.SpecularDir);
	float  specular=pow(saturate(dot(fvReflection, Input.SpecularDir)),64);//fSpecularPower);
	//specular=pow(saturate(dot(reflect(normalize(Input.ViewVector), normalize(Input.Normal)), Input.SpecularDir)),fSpecularPower);
	float4 specularLight=specular*fvSpecularColor;
	float3 tmp=(fvTotalDiffuse+specularLight*fvSpecularColor)*fExposure;
	float4 ret;
	ret.rgb=tmp.rgb;
	//ret.xyz=Input.Normal.xyz;
	//ret.x=fNDotL;
	//ret.y=fNDotL;
	//ret.z=fNDotL;
	ret.a=1;
	ret=specularLight+fvTotalDiffuse;
	///////dodac obsluge blenda i dofa
	///ret.a=Input.SpecularColor.a;
	return ret;   
   //return fColor;
}

///////////

technique RenderBlobs
{
    pass P0
    {      
        VertexShader = compile vs_2_0 vsBlobs();
        PixelShader  = compile ps_2_0 psBlobs();    
        //VertexShader = compile vs_2_0 vsBlobs();
        //PixelShader  = compile ps_2_0 psBlobs();
    }
}

technique RenderPRT
{
    pass P0
    {          
        VertexShader = compile vs_2_0 PRTDiffuseVS();
        PixelShader  = compile ps_2_0 PrtPS();
    }
}

technique RenderSprite
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsSprite();
	    PixelShader  = compile ps_2_0 psSprite();
	}
}

technique Render
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsDefault();
	    PixelShader  = compile ps_2_0 psDefault();
	}
}

technique RenderFader
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsDefault();
	    PixelShader  = compile ps_2_0 psFader();
	}
}

technique RenderCaustick
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsCaustick();
	    PixelShader  = compile ps_2_0 psCaustick();
	}
}

technique RenderMask
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsDefault();
	    PixelShader  = compile ps_2_0 psMask();
	}
}

/////////////////////
technique RenderBlur
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsBlur();
	    PixelShader  = compile ps_2_0 psBlur();
	}
}

technique RenderMorphBump
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsMorphBump();
	    PixelShader  = compile ps_2_0 psBump();
	}
}

technique RenderBump
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsBump();
	    PixelShader  = compile ps_2_0 psBump();
	}
}

technique RenderFly
{
	pass P0
	{
		VertexShader = compile vs_1_1 main();
		PixelShader  = compile ps_2_0 psFly();
	}
}

technique RenderLeafLight
{
	pass P0
	{
		VertexShader = compile vs_1_1 main();
		PixelShader  = compile ps_2_0 psLeaf();
	}
}

technique RenderPien
{
	pass P0
	{
		VertexShader = compile vs_1_1 main();
		PixelShader  = compile ps_2_0 psLeafPien();
	}
}

technique RenderLight
{
	pass P0
	{
		VertexShader = compile vs_1_1 main();
		PixelShader  = compile ps_2_0 ps_main();
	}
}

technique RenderHDR
{
	pass P0
	{
		VertexShader = compile vs_2_0 hdrVS();
	    PixelShader  = compile ps_2_0 hdrPS();
	}
}

technique RenderDOF
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsDOF();
	    PixelShader  = compile ps_2_0 psDOF();
	}
}

technique RenderDOFBW
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsDOF();
	    PixelShader  = compile ps_2_0 psDOFBW();
	}
}
