float4x4 viewProjMatrix: register(c0);
float time: register(c5);
float4x4 worldMatrix: register(c6);
//float4 cameraPos: register(c10);
float4 view_position: register(c4);


struct VS_OUTPUT {

   float4 pos:     POSITION;
   float4 normal:  TEXCOORD0;
   float3 viewVec: TEXCOORD1;
   //float2 texCoord:   TEXCOORD2;
   //float4 reflection:   TEXCOORD3;
   //float4 NdotV:    TEXCOORD4;
   
};

VS_OUTPUT vp_main(float4 position: POSITION, float4 normal: NORMAL, float2 texCoord: TEXCOORD,
            float4 tangent: TANGENT)
   //         uniform float4x4 viewProjMatrix,
   //         uniform float4x4 worldMatrix,
   //         uniform float4 cameraPos)
{
   VS_OUTPUT Out;

   const float TWO_PI = 6.2831853072;
   
   const float4 wave_directions_in_X   = {0, 4, 0, 4};      // relative to u
   const float4 wave_directions_in_Y   = {4, 0, 4, 0};      // relative to v

   const float4 waveSpeed         = {0.2, 0.3, 0.5, 0.6};
   const float4 waveHeights       = {0.5, 0.5, 0.25, 0.25};

   // use texture coordinates as inputs to sinusoidal warp
   float4 wave_vec = frac(   wave_directions_in_X*texCoord.x +
            wave_directions_in_Y*texCoord.y + waveSpeed*time );
      
   // shift the texture coordinates to be in (pi, -pi) range
   wave_vec = (wave_vec - 0.5) * TWO_PI;
      
   float4 wave_vec_sin = sin(wave_vec);
   float4 wave_vec_cos = (2 - cos(wave_vec))*0.04;      // multiply by 0.04 as fix up factor
                        
   // dot with waveHeights and then apply deformation in the direction of the normal
   wave_vec = dot(wave_vec_sin,waveHeights) * normal + position;
   wave_vec.w = 1;    // homogeneous component
   
   // transform wave vector 
   Out.pos = mul(viewProjMatrix, wave_vec);
   
   // compute the binomial
   float4 binomial = float4(cross(tangent.xyz, normal.xyz), 1);

   // warp normal based on tangent and binomial vectors
   float4 warpedNormal = tangent  * dot(-(wave_vec_cos * waveHeights), wave_directions_in_Y) +
               binomial * dot(-(wave_vec_cos * waveHeights), wave_directions_in_X);
   warpedNormal = warpedNormal + normal;

   // transform and normalize the normal
   warpedNormal = normalize(mul(worldMatrix, warpedNormal));
   
   /*// compute a normalized view vector
   float4 viewVector = normalize(cameraPos - mul(worldMatrix, wave_vec));
   
   // compute the reflection vector: R = 2*N(N.V) - V
   Out.reflection = 2*dot(warpedNormal.xyz, viewVector.xyz)*warpedNormal - viewVector;
   
   // pass to the pixel shader N.V
   Out.NdotV = dot(warpedNormal.xyz, viewVector.xyz);
   
   // pass along texture coordinates
   Out.texCoord = texCoord;*/

   //Out.normal = warpedNormal;
   //Out.viewVec = viewVector;
   Out.normal = normal;
   Out.viewVec = view_position - position;

   return Out;
}

