float noiseScale: register(c1);
float4 color: register(c2);
float4 gloss: register(c3);
float4 lightDir: register(c0);
sampler Noise: register(s0);
float4 fp_main(float3 normal: TEXCOORD0, float3 tangent: TEXCOORD1, float3 binormal: TEXCOORD2, float3 viewVec: TEXCOORD3, float3 pos: TEXCOORD4) : COLOR {
   viewVec = normalize(viewVec);

   // Grab an angle to rotate the tangent around the normal
   // This is done to create a slightly bumpy feeling
   float angle = noiseScale * (tex3D(Noise, pos) - 0.5);

   // Our angle is within the [-PI, PI] range and we need both
   // the sine and cosine. Perfect for the sincos function,
   // which will save us some hardware instructions over separate
   // sin and cos calls.
   float cosA, sinA;
   sincos(angle, sinA, cosA);

   // Rotate tangent around the normal
   float3 tang = sinA * tangent + cosA * binormal;

   // Do the anisotropic lighting
   float diffuse = saturate(dot(lightDir, normal));
   float cs = -dot(viewVec, tang);
   float sn = sqrt(1 - cs * cs);
   float cl = dot(lightDir, tang);
   float sl = sqrt(1 - cl * cl);
   float specular = pow(saturate(cs * cl + sn * sl), 32);

   // Output the results
   return diffuse * color + gloss * specular;
}


