varying vec3 normal;
//varying vec4 color;

#vertexshader

const int NUMBONES = 60;
uniform mat4 Bones[NUMBONES];

attribute vec4 Vertex;
//attribute vec3 Normal;
//attribute vec2 TexCoord;
//attribute vec2 TexCoord1;

varying vec3 NormalOut;
varying vec3 PosOut;
varying vec4 ColorOut;
void main()
{
	vec4 Pos0 = vec4(Vertex.xyz, 1.0);
	int index = int(Vertex.w);

	mat4 Bone = Bones[index];
	vec4 Pos = Bone * Pos0;
	PosOut = Pos.xyz;

	gl_Position = gl_ModelViewProjectionMatrix * Pos;
	Bone[3][0] = 0.0;
	Bone[3][1] = 0.0;
	Bone[3][2] = 0.0;
	NormalOut = normalize((gl_NormalMatrix * gl_Normal).xyz);
	
	ColorOut = gl_Color;
}

#fragmentshader

//uniform samplerCube Texture0;
varying vec3 NormalOut;
varying vec3 PosOut;
varying vec4 ColorOut;
//uniform sampler2D Texture0;
void main()
{
	vec3 lightdir = -normalize(PosOut);
	vec3 c = (dot(lightdir, NormalOut)+1.5)/2.0 * ColorOut.xyz;
	//vec3 c = NormalOut;
	gl_FragColor = vec4(c*2.0,1.0);
}
