varying vec3 normal;
//varying vec4 color;

#vertexshader

const int NUMBONES = 16;
uniform mat4 Bones[NUMBONES];
uniform mat4 JointNormals[NUMBONES];

attribute vec4 PosWeight0;
attribute vec4 Weights;

attribute vec4 Joints;
attribute vec4 Normal;

void main()
{
	vec4 Pos0 = vec4(PosWeight0.xyz, 1.0);

	int i0 = int(Joints.x);
	int i1 = int(Joints.y);
	int i2 = int(Joints.z);
	int i3 = int(Joints.w);

	vec4 Pos = (Bones[i0] * Pos0) * Weights.x;
	Pos += (Bones[i1] * Pos0) * Weights.y;
	Pos += (Bones[i2] * Pos0) * Weights.z;
	Pos += (Bones[i3] * Pos0) * Weights.w;

	vec4 Norm = (JointNormals[i0] * Normal) * Weights.x;
	Norm += (JointNormals[i1] * Normal) * Weights.y;
	Norm += (JointNormals[i2] * Normal) * Weights.z;
	Norm += (JointNormals[i3] * Normal) * Weights.w;

	gl_Position = gl_ModelViewProjectionMatrix * Pos;
	normal = normalize(Norm.xyz);
}

#fragmentshader

//uniform samplerCube Texture0;


void main()
{

	vec3 lightdir = normalize(vec3(-1.0,-1.0, 0.0));
	vec3 color = vec3(1.0, 0.4, 0.6);
	//vec4 color = textureCube(Texture0, normal); //vec3(0.15, 0.25, 0.4);
	float f = (dot(lightdir, normal)+1.0)/2.0;
	gl_FragColor = vec4(color*(f*0.6+0.4),1);


//	vec3 lightdir = normalize(vec3(1.0,1.0,1.0));
//	gl_FragColor = vec4((normal.xyz+vec3(1.0,1.0,1.0))*vec3(0.5,0.5,0.5),1.0);
}
