// force vc7 to group all shader related stuff into the Shader namespace
#ifdef WIN32
namespace Shader {
#endif

// VERTEX SHADER DESCRIPTION:
// Basic lighting with no texturing. Simulates the Fixed Pipeline's lighting model

// fragment program
void vp_main
(
	//varying parameters
	float4 position : POSITION,
	float3 normal : NORMAL,

	//output parameters
	out float4 oPosition : POSITION,
	out float4 oColor : COLOR,
 
	//uniform parameters
	uniform float4x4 modelViewProj,
	uniform float3 globalAmbient,
	uniform float3 lightColor,
	uniform float3 lightPosition,
	uniform float3 eyePosition,
	uniform float3 Ke,
	uniform float3 Ka,
	uniform float3 Kd,
	uniform float3 Ks,
	uniform float3 shininess
 )
 {

	oPosition = mul( modelViewProj, position );

	float3 P = position.xyz;
	float3 N = normal;

	float3 emissive = Ke;

	float3 ambient = Ka * globalAmbient;

	float3 L = normalize( lightPosition - P );
	float diffuseLight = max( dot( N, L ) , 0 );
	float3 diffuse = Kd * lightColor * diffuseLight;

	float3 V = normalize( eyePosition - P );
	float3 H = normalize( L + V );
	float specularLight = pow( max( dot( N, H ), 0), shininess );
	if (diffuseLight <= 0) specularLight = 0;
	float3 specular = Ks * lightColor * specularLight;

	//resultado
	oColor.rgb = emissive + ambient + diffuse + specular;
	oColor.a = 1;

}

#ifdef WIN32
}
#endif

