import java.io.*;
import javax.microedition.lcdui.*;

public class WallSphere extends LevelObject implements Collidable
{
    public int mode;
    public int bump_power;
    
    public int pos_x, pos_y;
    public int radius;
    public int radius2;
    public int color;
    
    private int m_bumper;
    
    /**
     * Updates the level object.
     * 
     * @param time_secs
     */
    public void update( int time_secs )
    {
        if ( mode == MODE_BUMPER )
        {
            m_bumper -= FP.mul( g_bumper_speed, time_secs );
            if ( m_bumper < g_bumper_min )
                m_bumper = g_bumper_min;
        }
    }

    /**
     * Renders the level object.
     */
    public void render( Graphics g, int top_x, int top_y, int scale_x, int scale_y )
    {
        int size_x = FP.toInt(FP.mul(radius,scale_x)*2);
        int size_y = FP.toInt(FP.mul(radius,scale_y)*2);
        int tl_x = FP.toInt( FP.mul(pos_x-radius-top_x, scale_x) );
        int tl_y = FP.toInt( FP.mul(pos_y-radius-top_y, scale_y) );
        
        g.setColor( color );
        g.fillArc( tl_x, tl_y, size_x, size_y, 0, 360 );
        
        // Bumping?
        if ( mode == MODE_BUMPER )
        {
            int bumper = FP.toInt( FP.mul( m_bumper, scale_x ) );
            g.drawArc( tl_x - bumper, tl_y - bumper, size_x + bumper*2, size_y + bumper*2, 0, 360 );
        }
    }
    
    /**
     * Loads the object from the stream.
     * 
     * @param in The data stream.
     * @throws IOException
     */
    public void load(DataInputStream in) throws IOException
    {
        // Read the position
        pos_x = in.readInt();
        pos_y = in.readInt();
        
        // Mode
        mode = in.readByte();
        
        // Bump power
        bump_power = in.readInt();
        
        // Color
        color = in.readInt();
        
        // Radius
        radius = in.readInt();
        radius2 = FP.mul( radius, radius );
    }

    /**
     * Resolves a possible verlet collision.
     * 
     * @param v The verlet.
     */
    public void resolveCollision( Verlet v )
    {
        if (mode == MODE_NO_COLLISIONS)
            return;
        
        // BBox test
        int dx = v.pos[0] - pos_x;
        int dy = v.pos[1] - pos_y;
        if (Math.abs(dx) >= radius || Math.abs(dy) >= radius)
            return;
        
        // Distance test
        int dist2 = FP.mul( dx, dx ) + FP.mul( dy, dy );
        if (dist2 >= radius2)
            return;
        
        // Normalize normal
        int dist = FP.sqrt( dist2 );
        if (dist <= 0)
            return;
        dx = FP.div( dx, dist );
        dy = FP.div( dy, dist );
        
        // Is this a bumper?
        if (mode == MODE_BUMPER)
        {
            level.star.bump(v, dx, dy, bump_power);
            
            m_bumper = g_bumper_max;
        }

        // Kill?
        if (mode == MODE_DEATH)
        {
            level.star.kill();
            return;
        }
        
        // Project the point out
        v.pos[0] = pos_x + FP.mul( dx, radius );
        v.pos[1] = pos_y + FP.mul( dy, radius );
        
        // Friction
        g_temp_vec[0] = -dy;
        g_temp_vec[1] = dx;
        v.applyFriction(g_temp_vec, g_friction_amount);
    }
    
    private static int[] g_temp_vec = new int[ 2 ];
    private static final int g_friction_amount = FP.toFP( 1.0f/*0.95f*/ );
    
    private static final int g_bumper_min = FP.toFP( 0.1f );
    private static final int g_bumper_max = FP.toFP( 0.4f );
    private static final int g_bumper_speed = FP.toFP( 2.f );
}
