import javax.microedition.lcdui.*;

public class LevelSelectScreen extends MenuBackgroundScreen
{
    private Screen m_next;
    
    private String[] m_items;
    
    private int m_sel_level;
    private int m_menu_sel;
    
    private int m_last_open_level;
    
    public LevelSelectScreen( int start_level )
    {
        m_items =
            new String[]
            {
                "Play",
                "Back",
            };
        
        m_sel_level = start_level;
        m_last_open_level = getLastOpenLevel();
     
        // Make sure that the menu music is playing
        Res.audio.playMusic( Res.audio.music_menu );
        
        // Unlock all for debug
        if (Res.debug_version)
            m_last_open_level = Res.manifest.entries.length - 1;
        
        // Select the last open level?
        if ( m_sel_level > m_last_open_level )
            m_sel_level = m_last_open_level;
        if ( m_sel_level == (m_last_open_level-1) &&
             Res.hiscores.getScore( m_last_open_level ) < 0 )
        {
            m_sel_level = m_last_open_level;
        }
    }
    
    /**
     * Updates the screen for a fixed amount of time.
     * 
     * @param fp_secs The time to update, in fixed point seconds.
     */
    public Screen updateFrame( int fp_secs )
    {
        if ( Res.manifest.entries.length == 0 )
            return new MainMenuScreen();
        if (m_next != null)
            return m_next;
        return null;
    }
    
    /**
     * Renders the current state to the given graphics.
     * 
     * @param g The destination graphics.
     * @param w The screen width.
     * @param h The screen height.
     */
    public void render( Graphics g, int w, int h )
    {
        super.render( g, w, h );
        
        Font f = Font.getFont( Font.FACE_MONOSPACE, Font.STYLE_BOLD, Font.SIZE_MEDIUM );
        g.setFont( f );
        int text_h = f.getHeight();
        
        // Get the entry
        int entry_count = Res.manifest.entries.length;
        if ( m_sel_level >= entry_count )
            return;
        Manifest.Entry entry = Res.manifest.entries[ m_sel_level ];
        
        // Show the level number
        int y = 5;
        
        g.setColor( 0xffafafaf );
        MiscUtils.writeShadowed( g, "#" + (m_sel_level+1) + " / " + (m_last_open_level+1) + "  (total: " + entry_count + ")", 5, y );
        y += text_h;
        
        // Get the hiscore
        int cur_score = Res.hiscores.getScore( m_sel_level );
        String cur_score_str = (cur_score < 0) ? "none" : MiscUtils.timeToString( cur_score );

        if (cur_score < 0)
            cur_score = FP.toFP(9999);
        
        // Show the entry
        g.setColor( 0xffafefaf );
        MiscUtils.writeCentered( g, entry.name, y, w );
        y += text_h * 2;
        
        int col_yes = 0xffffffa0;
        int col_no = 0xffafaf70;
        
        g.setColor( (cur_score <= entry.time_bronze) ? col_yes : col_no );
        MiscUtils.writeCentered( g, "Bronze: " + MiscUtils.timeToString( entry.time_bronze ), y, w );
        y += text_h;
        
        g.setColor( (cur_score <= entry.time_silver) ? col_yes : col_no );
        MiscUtils.writeCentered( g, "Silver: " + MiscUtils.timeToString( entry.time_silver ), y, w );
        y += text_h;

        g.setColor( (cur_score <= entry.time_gold) ? col_yes : col_no );
        MiscUtils.writeCentered( g, "Gold: " + MiscUtils.timeToString( entry.time_gold ), y, w );
        y += text_h * 2;
        
        // Show current
        g.setColor( 0xffa0a0ff );
        MiscUtils.writeCentered( g, "Current: " + cur_score_str, y, w );
        y += text_h;
        
        // Show the selection menu
        y += text_h;

        if ( m_last_open_level > 0 )
        {
            int side_text_y = y + text_h / 2;
            g.setColor( 0xffffffff );
            MiscUtils.writeCentered( g, "<<             >>", side_text_y, w );
        }
        
        for ( int i = 0; i < m_items.length; ++i )
        {
            if ( i == m_menu_sel )
                g.setColor( 0xffffffff );
            else
                g.setColor( 0xff888888 );
            
            MiscUtils.writeCentered( g, m_items[i], y, w );
            y += text_h;
        }
    }

    public void keyPressed( int key, int game_key )
    {
        if (game_key == Canvas.FIRE)
        {
            switch ( m_menu_sel )
            {
            case 0:
                m_next = new GameScreen( Res.manifest.entries[m_sel_level].res_name, m_sel_level );
                break;
            
            case 1:
                m_next = new MainMenuScreen();
                break;
            }
            return;
        }
        
        if (game_key == Canvas.UP)
        {
            m_menu_sel--;
            if (m_menu_sel < 0)
                m_menu_sel = m_items.length - 1;
        }
        
        if (game_key == Canvas.DOWN)
        {
            m_menu_sel++;
            if (m_menu_sel >= m_items.length)
                m_menu_sel = 0;
        }
        
        if (game_key == Canvas.LEFT)
        {
            m_sel_level--;
            if (m_sel_level < 0)
                m_sel_level = m_last_open_level;
        }
        
        if (game_key == Canvas.RIGHT)
        {
            m_sel_level++;
            if (m_sel_level > m_last_open_level)
                m_sel_level = 0;
        }
    }
    
    /**
     * Returns the level index of the last level that is unloacked.
     * 
     * @return The unlocked level index.
     */
    private int getLastOpenLevel()
    {
        if ( Res.manifest.entries.length <= 0 )
            return 0;
        if ( Res.hiscores.all_levels_unlocked )
            return Res.manifest.entries.length - 1;
        
        for ( int i = 0; i < Res.manifest.entries.length; ++i )
        {
            int bronze_time = Res.manifest.entries[i].time_bronze;
            int cur_time = Res.hiscores.getScore( i );
            
            if ( cur_time < 0 || cur_time > bronze_time )
                return i;
        }
        
        return Res.manifest.entries.length - 1;
    }
}
