import javax.microedition.lcdui.*;

/** 
 * The main game screen.
 */
public class GameScreen extends Screen
{
    private final static int END_PAUSE = FP.toFP( 1.5f );
    
    private String m_level_name;
    private int m_level_idx;
	private Level m_level;
    private int m_impulse = -1;
    private int m_rotate = 0;
    
    private boolean m_show_menu;
    
    private int m_end_pause;
    private boolean m_restart;
    
    public GameScreen(String level_name, int level_idx)
    {
        m_level_name = level_name;
        m_level_idx = level_idx;
        loadLevel();
    }
    
    /**
     * Returns the current level index.
     * 
     * @return Returns the current level index.
     */
    public int GetLevelIndex()
    {
        return m_level_idx;
    }
    
    /**
     * Updates the screen for a fixed amount of time.
     * 
     * @param fp_secs The time to update, in fixed point seconds.
     */
    public Screen updateFrame( int fp_secs )
    {
        // Quit to menu?
        if ( m_show_menu )
        {
            m_show_menu = false;
            return new GameMenuScreen( this );
        }
        
        // Restart level?
        boolean ended = false;
        if ( m_level.star.is_at_home || m_level.star.is_dead || m_restart )
        {
            ended = true;
        }
        
        if ( ended )
        {
            m_end_pause += fp_secs;
            if ( m_restart )
                m_end_pause = FP.toFP( 10 );
            
            if ( m_end_pause > END_PAUSE )
            {
                // So now what? Reload? Back to menu?
                if ( m_level.star.is_at_home &&
                     !m_restart &&
                     Res.editor_level_data == null )
                { // Level done
                    Res.hiscores.updateScore( m_level_idx, m_level.play_time );
                    return new LevelSelectScreen( m_level_idx );
                }
                
                // Reload level
                loadLevel();
            }
        }
        
        // Controls
        if ( !ended && m_impulse != -1 )
        {
            m_level.star.addImpulse( m_impulse );
            m_impulse = -1;
        }
        if ( !ended && m_rotate != -1 )
        {
            m_level.star.addRotation( m_rotate );
            m_rotate = -1;
        }
        
        // Update the level
    	m_level.update( fp_secs );
        return null;
    }
    
    /**
     * Restarts the game.
     */
    public void restart()
    {
        m_restart = true;
    }

    /**
     * Renders the current state to the given graphics.
     * 
     * @param g The destination graphics.
     * @param w The screen width.
     * @param h The screen height.
     */
    public void render( Graphics g, int w, int h )
    {
        g.setColor( 0xff203010 );
        g.fillRect( 0, 0, w, h );
        
        // Calculate the scaling factor and the center position
        int aspect = FP.toFP(w) / h;
        int scale_x = 0;
        int scale_y = 0;
        int vis_w = m_level.screen_width;
        int vis_h = m_level.screen_height;
        if (aspect <= m_level.screen_aspect)
        { // The screen is bigger in y
            scale_x = scale_y = FP.div( FP.toFP(w), m_level.screen_width );
            vis_h = FP.mul( vis_h, FP.div( m_level.screen_aspect, aspect ) );
        }
        else
        { // The screen is bigger in x
            scale_x = scale_y = FP.div( FP.toFP(h), m_level.screen_height );
            vis_w = FP.mul( vis_w, FP.div( aspect, m_level.screen_aspect ) );
        }
        
        int top_x = m_level.star.getX() - (vis_w>>1);
        int top_y = m_level.star.getY() - (vis_h>>1);
        
        // Render the level
        m_level.render( g, top_x, top_y, scale_x, scale_y, vis_w, vis_h, w, h );

        // Menu tooltip
        if (!Res.pc_mode)
        {
            Font f = Font.getFont( Font.FACE_PROPORTIONAL, Font.STYLE_BOLD | Font.STYLE_ITALIC, Font.SIZE_MEDIUM );
            String str = "[#] Menu";
            int str_w = f.stringWidth( str );
            int str_h = f.getHeight();
            
            g.setColor( 0xff111111 );
            g.setFont(f);
            g.fillRect( 0, h - str_h - 2, 4 + str_w, 2 + str_h );
            
            g.setColor( 0xffffffff );
            g.drawString( str, 2, h - str_h - 2, Graphics.TOP | Graphics.LEFT );
        }
    }
    
    public void keyPressed( int key, int game_key )
    {
        switch ( key )
        {
/*      case Canvas.KEY_NUM2:		m_impulse = 0; break;
        case Canvas.KEY_NUM6:		m_impulse = 1; break;
        case Canvas.KEY_NUM9:		m_impulse = 2; break;
        case Canvas.KEY_NUM7:		m_impulse = 3; break;
        case Canvas.KEY_NUM4:		m_impulse = 4; break;*/

/*        case Canvas.KEY_NUM1:       m_rotate = -1; break;
        case Canvas.KEY_NUM4:       m_rotate = -1; break;
        case Canvas.KEY_NUM7:       m_rotate = -1; break;
        case Canvas.KEY_NUM3:       m_rotate = 1; break;
        case Canvas.KEY_NUM6:       m_rotate = 1; break;
        case Canvas.KEY_NUM9:       m_rotate = 1; break;*/
        
        case Canvas.KEY_NUM4:       m_rotate = Level.DIR_LEFT; return;
        case Canvas.KEY_NUM6:       m_rotate = Level.DIR_RIGHT; return;
        case Canvas.KEY_NUM2:       m_rotate = Level.DIR_UP; return;
        case Canvas.KEY_NUM8:       m_rotate = Level.DIR_DOWN; return;
        
        case Canvas.KEY_STAR:
        case Canvas.KEY_POUND:      m_show_menu = true; return;
        }
        
        if (Res.pc_mode && key == 27)
        {
            m_show_menu = true;
            return;
        }
        
        switch ( game_key )
        {
        case Canvas.LEFT:           m_rotate = Level.DIR_LEFT; return;
        case Canvas.RIGHT:          m_rotate = Level.DIR_RIGHT; return;
        case Canvas.UP:             m_rotate = Level.DIR_UP; return;
        case Canvas.DOWN:           m_rotate = Level.DIR_DOWN; return;
        }
    }
    
    private void loadLevel()
    {
        // Reset the start of level parameters
        m_end_pause = 0;
        m_restart = false;

        // Load the level
        if (Res.editor_level_data != null)
            m_level = new Level(Res.editor_level_data);
        else
        {
            int top_score = Res.hiscores.getScore( m_level_idx );
            m_level = new Level(m_level_name, top_score);
        }
        
        // Start the music
        Res.audio.playMusic( null );
        if ( (m_level_idx & 1) == 0 )
            Res.audio.playMusic( Res.audio.music_game );
        else
            Res.audio.playMusic( Res.audio.music_game2 );
    }
}
