package javax.microedition.midlet;

import javax.microedition.lcdui.Display;

public abstract class MIDlet
{
    public static boolean g_allow_exit = false;
    
    public Display g_display;
    
    public MIDlet()
    {
        g_display = new Display( this );
    }
    
    protected abstract void startApp() throws MIDletStateChangeException;
    protected abstract void pauseApp();
    protected abstract void destroyApp( boolean uncond ) throws MIDletStateChangeException;

    public void notifyDestroyed()
    {
        if ( g_allow_exit )
            System.exit(0);
    }
    
    public void doStartApp() throws MIDletStateChangeException
    {
        startApp();
    }
    public void doPauseApp()
    {
        pauseApp();
    }
    public void doDestroyApp(boolean unconditional) throws MIDletStateChangeException
    {
        destroyApp(unconditional);
    }
}
