package javax.microedition.lcdui;

import java.awt.image.BufferedImage;
import java.util.*;

public class Font
{
    public java.awt.Font font;

    public static final int FACE_SYSTEM = 0;
    public static final int FACE_MONOSPACE = 32;
    public static final int FACE_PROPORTIONAL = 64;

    public static final int FONT_INPUT_TEXT = 1;
    public static final int FONT_STATIC_TEXT = 0;

    public static final int SIZE_MEDIUM = 0;
    public static final int SIZE_SMALL = 8;
    public static final int SIZE_LARGE = 16;

    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINED = 4;

    private static HashMap g_fonts = new HashMap();
    
    public static Font getFont(int face, int style, int size)
    {
        return new Font(face, style, size);
    }

    public int charsWidth(char[] ch, int offset, int length)
    {
        return g_tmp_img_g.getFontMetrics(font).charsWidth( ch, offset, length );
    }
    
    public int charWidth(char c)
    {
        return g_tmp_img_g.getFontMetrics(font).charWidth( c );
    }
    
    public int stringWidth(String s)
    {
        return g_tmp_img_g.getFontMetrics(font).stringWidth( s );
    }

    public int getHeight()
    {
        return g_tmp_img_g.getFontMetrics(font).getHeight();
    }
    
    public int getBaselinePosition()
    {
        return g_tmp_img_g.getFontMetrics(font).getAscent();
    }

    private Font(int face, int style, int size)
    {
        String name = "dialog-";
        
        if ( style == STYLE_BOLD )                      name += "BOLD";
        else if ( style == STYLE_ITALIC )               name += "ITALIC";
        else if ( style == (STYLE_BOLD|STYLE_ITALIC) )  name += "BOLDITALIC";
        else                                            name += "PLAIN";

        int fsize = 12;
        if (size == SIZE_MEDIUM)
            fsize = 16;
        if (size == SIZE_LARGE)
            fsize = 20;
        name += "-" + fsize;

        // Get the font
        if ( g_fonts.containsKey( name ) )
            font = (java.awt.Font) g_fonts.get( name );
        else
        {
            font = java.awt.Font.decode( name );
            if ( font == null )
                throw new Error( "Error fetching font: " + name );
            g_fonts.put( name, font );
        }
    }
    
    private static BufferedImage g_temp_img = new BufferedImage( 1, 1, BufferedImage.TYPE_4BYTE_ABGR );
    private static java.awt.Graphics2D g_tmp_img_g = g_temp_img.createGraphics();

}
